/*
 * Created on 2004/11/15
 */
package org.asyrinx.brownie.pdf.fop.impl;

import java.io.File;
import java.io.OutputStream;

import org.apache.commons.lang.StringUtils;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Options;
import org.apache.fop.apps.XSLTInputHandler;
import org.xml.sax.InputSource;

/**
 * @author takeshi
 */
public class FopInvokerImpl extends AbstractFopInvoker {

    /**
     *  
     */
    public FopInvokerImpl() {
        super();
    }

    private String config = null;

    public void execute(InputSource source, InputSource xsl, OutputStream dest)
            throws FOPException {
        final XSLTInputHandler input = new XSLTInputHandler(source, xsl);
        configureFop();
        final Driver driver = new Driver();
        driver.setRenderer(Driver.RENDER_PDF);
        driver.setOutputStream(dest);
        input.run(driver);
    }

    protected void configureFop() throws FOPException {
        if (StringUtils.isEmpty(getConfig()))
            return;
        //ꂾstaticȃRtBOݒɂȂ炵
        final File userConfigFile = new File(getConfig());
        new Options(userConfigFile);
    }

    /**
     * @return Returns the configDir.
     */
    public String getConfig() {
        return config;
    }

    /**
     * @param configDir
     *               The configDir to set.
     */
    public void setConfig(String configDir) {
        this.config = configDir;
    }

}