/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/18
 */
package org.asyrinx.brownie.jdbc;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.asyrinx.brownie.core.io.sf.StreamFactory;
import org.asyrinx.brownie.core.io.sf.StreamFactoryFacade;
import org.asyrinx.brownie.core.io.sf.StringLoader;
import org.asyrinx.brownie.jdbc.wrapper.StatementWrapper;

/**
 * @author akima
 */
public final class SqlLoadableStatement extends StatementWrapper {

	/**
	 * 
	 * @param source
	 */
	SqlLoadableStatement(Statement source, StreamFactoryFacade baseStreamFactory) {
		super(source);
		this.streamFactory = SqlLoadableConnection.newFactory(
				SqlLoadableStatement.class.getName(), baseStreamFactory);
		this.loader = new StringLoader(streamFactory);
	}

	private final StreamFactory streamFactory;

	private final StringLoader loader;

	protected final String load(String key) throws SQLException {
		try {
			return loader.load(key);
		} catch (IOException e) {
			throw new SQLException(e.getMessage());
		}
	}

	/**
	 * @see org.asyrinx.jdbc.wrapper.StatementWrapper#execute(java.lang.String)
	 */
	public boolean executeFromFile(String sqlKey) throws SQLException {
		return super.execute(load(sqlKey));
	}

	/**
	 * @see org.asyrinx.jdbc.wrapper.StatementWrapper#execute(java.lang.String,
	 *      int)
	 */
	public boolean executeFromFile(String sqlKey, int autoGeneratedKeys)
			throws SQLException {
		return super.execute(load(sqlKey), autoGeneratedKeys);
	}

	/**
	 * @see org.asyrinx.jdbc.wrapper.StatementWrapper#execute(java.lang.String,
	 *      int[])
	 */
	public boolean executeFromFile(String sqlKey, int[] columnIndexes)
			throws SQLException {
		return super.execute(load(sqlKey), columnIndexes);
	}

	/**
	 * @see org.asyrinx.jdbc.wrapper.StatementWrapper#execute(java.lang.String,
	 *      java.lang.String[])
	 */
	public boolean executeFromFile(String sqlKey, String[] columnNames)
			throws SQLException {
		return super.execute(load(sqlKey), columnNames);
	}

	/**
	 * @see org.asyrinx.jdbc.wrapper.StatementWrapper#executeQuery(java.lang.String)
	 */
	public ResultSet executeQueryFromFile(String sqlKey) throws SQLException {
		return super.executeQuery(load(sqlKey));
	}

	/**
	 * @see org.asyrinx.jdbc.wrapper.StatementWrapper#executeUpdate(java.lang.String)
	 */
	public int executeUpdateFromFile(String sqlKey) throws SQLException {
		return super.executeUpdate(load(sqlKey));
	}

	/**
	 * @see org.asyrinx.jdbc.wrapper.StatementWrapper#executeUpdate(java.lang.String,
	 *      int)
	 */
	public int executeUpdateFromFile(String sqlKey, int autoGeneratedKeys)
			throws SQLException {
		return super.executeUpdate(load(sqlKey), autoGeneratedKeys);
	}

	/**
	 * @see org.asyrinx.jdbc.wrapper.StatementWrapper#executeUpdate(java.lang.String,
	 *      int[])
	 */
	public int executeUpdateFromFile(String sqlKey, int[] columnIndexes)
			throws SQLException {
		return super.executeUpdate(load(sqlKey), columnIndexes);
	}

	/**
	 * @see org.asyrinx.jdbc.wrapper.StatementWrapper#executeUpdate(java.lang.String,
	 *      java.lang.String[])
	 */
	public int executeUpdateFromFile(String sqlKey, String[] columnNames)
			throws SQLException {
		return super.executeUpdate(load(sqlKey), columnNames);
	}
}