/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/29
 */
package org.asyrinx.brownie.hibernate.logger;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import net.sf.hibernate.Criteria;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.Query;
import net.sf.hibernate.ReplicationMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.type.Type;

import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.hibernate.wrapper.SessionWrapper;
import org.asyrinx.brownie.jdbc.logger.LogConnection;

/**
 * @author akima
 */
public class LogSession extends SessionWrapper {

    /**
     * @param wrapped
     * @param log
     */
    public LogSession(Session wrapped, CascadeNamedLog parentLog) {
        super(wrapped);
        this.log = parentLog.subLog(wrapped);
    }

    protected final CascadeNamedLog log;

    /**
     * @see net.sf.hibernate.Session#beginTransaction()
     */
    public Transaction beginTransaction() throws HibernateException {
        final Transaction result = super.beginTransaction();
        log.log("beginTransaction()");
        return new LogTransaction(result, log.subLog(result));
    }

    /**
     * @see net.sf.hibernate.Session#cancelQuery()
     */
    public void cancelQuery() throws HibernateException {
        log.log("cancelQuery()");
        super.cancelQuery();
    }

    /**
     * @see net.sf.hibernate.Session#clear()
     */
    public void clear() {
        log.log("clear()");
        super.clear();
    }

    /**
     * @see net.sf.hibernate.Session#close()
     */
    public Connection close() throws HibernateException {
        final Connection result = super.close();
        log.log("close()");
        return new LogConnection(result, log.subLog(result));
    }

    /**
     * @see net.sf.hibernate.Session#connection()
     */
    public Connection connection() throws HibernateException {
        final Connection result = super.connection();
        log.log("connection()");
        return new LogConnection(result, log.subLog(result));
    }

    /**
     * @see net.sf.hibernate.Session#contains(java.lang.Object)
     */
    public boolean contains(Object object) {
        log.log("contains(" + object + ")");
        return super.contains(object);
    }

    /**
     * @see net.sf.hibernate.Session#createCriteria(java.lang.Class)
     */
    public Criteria createCriteria(Class persistentClass) {
        final Criteria result = super.createCriteria(persistentClass);
        log.log("createCriteria(" + persistentClass + ")");
        return new LogCriteria(result, log.subLog(result));
    }

    /**
     * @see net.sf.hibernate.Session#createFilter(java.lang.Object,
     *      java.lang.String)
     */
    public Query createFilter(Object collection, String queryString) throws HibernateException {
        final Query result = super.createFilter(collection, queryString);
        log.log("createFilter(" + collection + ", " + queryString + ")");
        return new LogQuery(result, log.subLog(result));
    }

    /**
     * @see net.sf.hibernate.Session#createQuery(java.lang.String)
     */
    public Query createQuery(String queryString) throws HibernateException {
        final Query result = super.createQuery(queryString);
        log.log("createQuery(" + queryString + ")");
        return new LogQuery(result, log.subLog(result));
    }

    /**
     * @see net.sf.hibernate.Session#createSQLQuery(java.lang.String,
     *      java.lang.String, java.lang.Class)
     */
    public Query createSQLQuery(String sql, String returnAlias, Class returnClass) {
        final Query result = super.createSQLQuery(sql, returnAlias, returnClass);
        log.log("createQuery(" + sql + ", " + returnAlias + ", " + returnClass.getName() + ", " + ")");
        return new LogQuery(result, log.subLog(result));
    }

    /**
     * @see net.sf.hibernate.Session#createSQLQuery(java.lang.String,
     *      java.lang.String[], java.lang.Class[])
     */
    public Query createSQLQuery(String sql, String[] returnAliases, Class[] returnClasses) {
        final Query result = super.createSQLQuery(sql, returnAliases, returnClasses);
        log.log("createQuery(" + sql + ", " + returnAliases + ", " + returnClasses + ", " + ")");
        return new LogQuery(result, log.subLog(result));
    }

    /**
     * @see net.sf.hibernate.Session#delete(java.lang.Object)
     */
    public void delete(Object object) throws HibernateException {
        log.log("delete(" + object + ")");
        super.delete(object);
    }

    /**
     * @see net.sf.hibernate.Session#delete(java.lang.String, java.lang.Object,
     *      net.sf.hibernate.type.Type)
     */
    public int delete(String query, Object value, Type type) throws HibernateException {
        log.log("delete(" + query + ", " + value + ", " + type + ")");
        return super.delete(query, value, type);
    }

    /**
     * @see net.sf.hibernate.Session#delete(java.lang.String,
     *      java.lang.Object[], net.sf.hibernate.type.Type[])
     */
    public int delete(String query, Object[] values, Type[] types) throws HibernateException {
        log.log("delete(" + query + ", " + values + ", " + types + ")");
        return super.delete(query, values, types);
    }

    /**
     * @see net.sf.hibernate.Session#delete(java.lang.String)
     */
    public int delete(String query) throws HibernateException {
        log.log("delete(" + query + ")");
        return super.delete(query);
    }

    /**
     * @see net.sf.hibernate.Session#disconnect()
     */
    public Connection disconnect() throws HibernateException {
        final Connection result = super.disconnect();
        log.log("disconnect()");
        return new LogConnection(result, log.subLog(result));
    }

    /**
     * @see net.sf.hibernate.Session#evict(java.lang.Object)
     */
    public void evict(Object object) throws HibernateException {
        log.log("evict(" + object + ")");
        super.evict(object);
    }

    /**
     * @see net.sf.hibernate.Session#filter(java.lang.Object, java.lang.String,
     *      java.lang.Object, net.sf.hibernate.type.Type)
     */
    public Collection filter(Object collection, String filter, Object value, Type type) throws HibernateException {
        log.log("filter(" + collection + ", " + filter + ", " + value + ", " + type + ")");
        return super.filter(collection, filter, value, type);
    }

    /**
     * @see net.sf.hibernate.Session#filter(java.lang.Object, java.lang.String,
     *      java.lang.Object[], net.sf.hibernate.type.Type[])
     */
    public Collection filter(Object collection, String filter, Object[] values, Type[] types) throws HibernateException {
        log.log("filter(" + collection + ", " + filter + ", " + values + ", " + types + ")");
        return super.filter(collection, filter, values, types);
    }

    /**
     * @see net.sf.hibernate.Session#filter(java.lang.Object, java.lang.String)
     */
    public Collection filter(Object collection, String filter) throws HibernateException {
        log.log("filter(" + collection + ", " + filter + ")");
        return super.filter(collection, filter);
    }

    /**
     * @see net.sf.hibernate.Session#find(java.lang.String, java.lang.Object,
     *      net.sf.hibernate.type.Type)
     */
    public List find(String query, Object value, Type type) throws HibernateException {
        log.log("find(" + query + ", " + value + ", " + type + ")");
        return super.find(query, value, type);
    }

    /**
     * @see net.sf.hibernate.Session#find(java.lang.String, java.lang.Object[],
     *      net.sf.hibernate.type.Type[])
     */
    public List find(String query, Object[] values, Type[] types) throws HibernateException {
        log.log("find(" + query + ", " + values + ", " + types + ")");
        return super.find(query, values, types);
    }

    /**
     * @see net.sf.hibernate.Session#find(java.lang.String)
     */
    public List find(String query) throws HibernateException {
        log.log("find(" + query + ")");
        return super.find(query);
    }

    /**
     * @see net.sf.hibernate.Session#flush()
     */
    public void flush() throws HibernateException {
        log.log("flush()");
        super.flush();
    }

    /**
     * @see net.sf.hibernate.Session#get(java.lang.Class, java.io.Serializable,
     *      net.sf.hibernate.LockMode)
     */
    public Object get(Class clazz, Serializable id, LockMode lockMode) throws HibernateException {
        log.log("get(" + clazz + "," + id + "," + lockMode + ")");
        return super.get(clazz, id, lockMode);
    }

    /**
     * @see net.sf.hibernate.Session#get(java.lang.Class, java.io.Serializable)
     */
    public Object get(Class clazz, Serializable id) throws HibernateException {
        log.log("get(" + clazz + "," + id + ")");
        return super.get(clazz, id);
    }

    /**
     * @see net.sf.hibernate.Session#getCurrentLockMode(java.lang.Object)
     */
    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        return super.getCurrentLockMode(object);
    }

    /**
     * @see net.sf.hibernate.Session#getFlushMode()
     */
    public FlushMode getFlushMode() {
        return super.getFlushMode();
    }

    /**
     * @see net.sf.hibernate.Session#getIdentifier(java.lang.Object)
     */
    public Serializable getIdentifier(Object object) throws HibernateException {
        log.log("getIdentifier(" + object + ")");
        return super.getIdentifier(object);
    }

    /**
     * @see net.sf.hibernate.Session#getNamedQuery(java.lang.String)
     */
    public Query getNamedQuery(String queryName) throws HibernateException {
        final Query result = super.getNamedQuery(queryName);
        log.log("getNamedQuery(" + queryName + ")");
        return new LogQuery(result, log.subLog(result));
    }

    /**
     * @see net.sf.hibernate.Session#getSessionFactory()
     */
    public SessionFactory getSessionFactory() {
        final SessionFactory result = super.getSessionFactory();
        log.log("getSessionFactory()");
        return new LogSessionFactory(result, log.subLog(result));
    }

    /**
     * @see net.sf.hibernate.Session#isConnected()
     */
    public boolean isConnected() {
        return super.isConnected();
    }

    /**
     * @see net.sf.hibernate.Session#isOpen()
     */
    public boolean isOpen() {
        return super.isOpen();
    }

    /**
     * @see net.sf.hibernate.Session#iterate(java.lang.String, java.lang.Object,
     *      net.sf.hibernate.type.Type)
     */
    public Iterator iterate(String query, Object value, Type type) throws HibernateException {
        return super.iterate(query, value, type);
    }

    /**
     * @see net.sf.hibernate.Session#iterate(java.lang.String,
     *      java.lang.Object[], net.sf.hibernate.type.Type[])
     */
    public Iterator iterate(String query, Object[] values, Type[] types) throws HibernateException {
        return super.iterate(query, values, types);
    }

    /**
     * @see net.sf.hibernate.Session#iterate(java.lang.String)
     */
    public Iterator iterate(String query) throws HibernateException {
        return super.iterate(query);
    }

    /**
     * @see net.sf.hibernate.Session#load(java.lang.Class, java.io.Serializable,
     *      net.sf.hibernate.LockMode)
     */
    public Object load(Class theClass, Serializable id, LockMode lockMode) throws HibernateException {
        log.log("load(" + theClass + ", " + id + ", " + lockMode + ")");
        return super.load(theClass, id, lockMode);
    }

    /**
     * @see net.sf.hibernate.Session#load(java.lang.Class, java.io.Serializable)
     */
    public Object load(Class theClass, Serializable id) throws HibernateException {
        log.log("load(" + theClass + ", " + id + ")");
        return super.load(theClass, id);
    }

    /**
     * @see net.sf.hibernate.Session#load(java.lang.Object,
     *      java.io.Serializable)
     */
    public void load(Object object, Serializable id) throws HibernateException {
        log.log("load(" + object + ", " + id + ")");
        super.load(object, id);
    }

    /**
     * @see net.sf.hibernate.Session#lock(java.lang.Object,
     *      net.sf.hibernate.LockMode)
     */
    public void lock(Object object, LockMode lockMode) throws HibernateException {
        log.log("lock(" + object + ", " + lockMode + ")");
        super.lock(object, lockMode);
    }

    /**
     * @see net.sf.hibernate.Session#reconnect()
     */
    public void reconnect() throws HibernateException {
        log.log("reconnect()");
        super.reconnect();
    }

    /**
     * @see net.sf.hibernate.Session#reconnect(java.sql.Connection)
     */
    public void reconnect(Connection connection) throws HibernateException {
        log.log("reconnect(" + connection + ")");
        super.reconnect(connection);
    }

    /**
     * @see net.sf.hibernate.Session#refresh(java.lang.Object,
     *      net.sf.hibernate.LockMode)
     */
    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        log.log("refresh(" + object + ", " + lockMode + ")");
        super.refresh(object, lockMode);
    }

    /**
     * @see net.sf.hibernate.Session#refresh(java.lang.Object)
     */
    public void refresh(Object object) throws HibernateException {
        log.log("refresh(" + object + ")");
        super.refresh(object);
    }

    /**
     * @see net.sf.hibernate.Session#replicate(java.lang.Object,
     *      net.sf.hibernate.ReplicationMode)
     */
    public void replicate(Object object, ReplicationMode replicationMode) throws HibernateException {
        log.log("replicate(" + object + ", " + replicationMode + ")");
        super.replicate(object, replicationMode);
    }

    /**
     * @see net.sf.hibernate.Session#save(java.lang.Object,
     *      java.io.Serializable)
     */
    public void save(Object object, Serializable id) throws HibernateException {
        log.log("save(" + object + ", " + id + ")");
        super.save(object, id);
    }

    /**
     * @see net.sf.hibernate.Session#save(java.lang.Object)
     */
    public Serializable save(Object object) throws HibernateException {
        log.log("save(" + object + ")");
        return super.save(object);
    }

    /**
     * @see net.sf.hibernate.Session#saveOrUpdate(java.lang.Object)
     */
    public void saveOrUpdate(Object object) throws HibernateException {
        log.log("saveOrUpdate(" + object + ")");
        super.saveOrUpdate(object);
    }

    /**
     * @see net.sf.hibernate.Session#saveOrUpdateCopy(java.lang.Object,
     *      java.io.Serializable)
     */
    public Object saveOrUpdateCopy(Object object, Serializable id) throws HibernateException {
        log.log("saveOrUpdateCopy(" + object + ", " + id + ")");
        return super.saveOrUpdateCopy(object, id);
    }

    /**
     * @see net.sf.hibernate.Session#saveOrUpdateCopy(java.lang.Object)
     */
    public Object saveOrUpdateCopy(Object object) throws HibernateException {
        log.log("saveOrUpdateCopy(" + object + ")");
        return super.saveOrUpdateCopy(object);
    }

    /**
     * @see net.sf.hibernate.Session#setFlushMode(net.sf.hibernate.FlushMode)
     */
    public void setFlushMode(FlushMode flushMode) {
        log.log("setFlushMode(" + flushMode + ")");
        super.setFlushMode(flushMode);
    }

    /**
     * @see net.sf.hibernate.Session#update(java.lang.Object,
     *      java.io.Serializable)
     */
    public void update(Object object, Serializable id) throws HibernateException {
        log.log("update(" + object + ", " + id + ")");
        super.update(object, id);
    }

    /**
     * @see net.sf.hibernate.Session#update(java.lang.Object)
     */
    public void update(Object object) throws HibernateException {
        log.log("update(" + object + ")");
        super.update(object);
    }

}