/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/10/26 17:28:15
 */
package org.asyrinx.brownie.core.xml.digester;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.digester.Digester;

/**
 * @author takeshi
 */
public class SetPropertiesWithOptionsRule extends SetPropertiesRule {

    /**
     * @param digester
     * @deprecated
     */
    public SetPropertiesWithOptionsRule(Digester digester) {
        super(digester);
    }

    /**
     *  
     */
    public SetPropertiesWithOptionsRule() {
        super();
    }

    /**
     *  
     */
    public SetPropertiesWithOptionsRule(String optionsPropertyName) {
        super();
        this.optionsPropertyName = optionsPropertyName;
    }

    /**
     * @param attributeName
     * @param propertyName
     */
    public SetPropertiesWithOptionsRule(String attributeName, String propertyName) {
        super(attributeName, propertyName);
    }

    /**
     * @param attributeName
     * @param propertyName
     */
    public SetPropertiesWithOptionsRule(String attributeName, String propertyName, String optionsPropertyName) {
        super(attributeName, propertyName);
        this.optionsPropertyName = optionsPropertyName;
    }

    /**
     * @param attributeNames
     * @param propertyNames
     */
    public SetPropertiesWithOptionsRule(String[] attributeNames, String[] propertyNames) {
        super(attributeNames, propertyNames);
    }

    /**
     * @param attributeNames
     * @param propertyNames
     */
    public SetPropertiesWithOptionsRule(String[] attributeNames, String[] propertyNames, String optionsPropertyName) {
        super(attributeNames, propertyNames);
        this.optionsPropertyName = optionsPropertyName;
    }

    private String optionsPropertyName = "options";

    /**
     * @return Returns the optionsPropertyName.
     */
    public String getOptionsPropertyName() {
        return optionsPropertyName;
    }

    /**
     * @param optionsPropertyName
     *            The optionsPropertyName to set.
     */
    public void setOptionsPropertyName(String optionsPropertyName) {
        this.optionsPropertyName = optionsPropertyName;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.xml.digester.SetPropertiesRule#populateBean(java.util.HashMap,
     *      java.lang.Object)
     */
    protected void populateBean(HashMap values, Object bean) throws Exception {
        super.populateBean(values, bean);
        //
        final Object obj;
        try {
            obj = PropertyUtils.getProperty(bean, getOptionsPropertyName());
        } catch (NoSuchMethodException e) {
            return;
        }
        if (obj == null)
            return;
        if (!(obj instanceof Map)) {
            log.warn(bean.getClass().getName() + "#" + getOptionsPropertyName() + " is not a Map");
            return;
        }
        final Map dest = (Map) obj;
        final Map beanValues;
        try {
            beanValues = BeanUtils.describe(bean);
        } catch (InvocationTargetException e) {
            log.error("bean: " + bean, e);
            return;
        }
        for (Iterator i = values.keySet().iterator(); i.hasNext();) {
            final String propertyName = i.next().toString();
            if (!beanValues.keySet().contains(propertyName)) {
                dest.put(propertyName, values.get(propertyName));
            }
        }
    }
}