/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/16 17:09:09
 */
package org.asyrinx.brownie.core.xml.digester;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.digester.Rule;

/**
 * @author akima
 */
public class SetBodyToPropertyRule extends Rule {

    /**
     *  
     */
    public SetBodyToPropertyRule(String propertyName) {
        super();
        this.propertyName = propertyName;
    }

    private final String propertyName;

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.commons.digester.Rule#body(java.lang.String,
     *        java.lang.String, java.lang.String)
     */
    public void body(String namespace, String name, String text) throws Exception {
        final Object bean = digester.peek(0);
        BeanUtils.setProperty(bean, propertyName, text);
    }

}