/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/03/01
 */
package org.asyrinx.brownie.core.sql2;

/**
 * @author akima
 */
public class Tables extends Elements {

	public void accept(Visitor visitor) {
		visitor.visit(this);
	}

	/**
	 * e[uQǉ܂B
	 * 
	 * @param tables
	 */
	public Tables addNewTables() {
		final Tables result = new Tables();
		super.addImpl(result);
		return result;
	}

	/**
	 * e[uǉ܂B
	 * 
	 * @param table
	 */
	public Tables add(String table) {
		return add(null, table);
	}

	/**
	 * e[uǉ܂B <br>
	 * e[ũvtBbNXAe[uʁXɎwł܂B <br>
	 * 
	 * @param tablePrefix
	 * @param tableName
	 */
	public Tables add(String tablePrefix, String tableName) {
		return add(tablePrefix, tableName, null);
	}

	/**
	 * e[uǉ܂B <br>
	 * e[ũvtBbNXAe[uAGCAXʁXɎwł܂B <br>
	 * 
	 * @param tablePrefix
	 * @param tableName
	 * @param tableAlias
	 */
	public Tables add(String tablePrefix, String tableName, String tableAlias) {
		return add(tablePrefix, tableName, tableAlias, null);
	}

	/**
	 * e[uǉ܂B <br>
	 * e[ũvtBbNXAe[uAGCAXACfbNXʁXɎwł܂B <br>
	 * 
	 * @param tablePrefix
	 * @param tableName
	 * @param tableAlias
	 * @param indexName
	 */
	public Tables add(String tablePrefix, String tableName, String tableAlias,
			String indexName) {
		final Table result = new Table();
		result.setTablePrefix(tablePrefix);
		result.setTableName(tableName);
		result.setTableAlias(tableAlias);
		result.setIndexName(indexName);
		addImpl(result);
		return this;
	}

}