/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/07
 */
package org.asyrinx.brownie.core.lang.enum;

import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.enum.Enum;

/**
 * @author akima
 */
public class ValuedEnum extends Enum {

	/**
	 * @param name
	 */
	public ValuedEnum(String name, Object value) {
		super(name);
		this.value = value;
	}

	private final Object value;

	/**
	 * @return
	 */
	public Object getValue() {
		return value;
	}

	public static ValuedEnum getEnum(Class enumClass, Object value) {
		if (enumClass == null) {
			throw new IllegalArgumentException(
					"The Enum Class must not be null");
		}
		final List list = Enum.getEnumList(enumClass);
		for (Iterator it = list.iterator(); it.hasNext();) {
			ValuedEnum enum = (ValuedEnum) it.next();
			if (enum.getValue().equals(value))
				return enum;
		}
		return null;
	}

	public static ValuedEnum getEnumByName(Class enumClass, String name) {
		return (ValuedEnum) Enum.getEnum(enumClass, name);
	}
}