/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/13
 */
package org.asyrinx.brownie.core.lang;

/**
 * @author akima
 */
public class PropertyUtils extends org.apache.commons.beanutils.PropertyUtils {

	public static String getPropertyAsString(Object object, String propName) {
		return getPropertyAsString(object, propName, null);
	}

	public static String getPropertyAsString(Object object, String propName,
			String defaultValue) {
		try {
			return String.valueOf(getProperty(object, propName));
		} catch (Exception e) {
			return defaultValue;
		}
	}

	public static int getPropertyAsInt(Object object, String propName) {
		return getPropertyAsInt(object, propName, 0);
	}

	public static int getPropertyAsInt(Object object, String propName,
			int defaultValue) {
		final Object result;
		try {
			result = getProperty(object, propName);
		} catch (Exception e) {
			return defaultValue;
		}
		if (result instanceof Number)
			return ((Number) result).intValue();
		else if (result instanceof String)
			return NumberUtils.toInt(result, 0);
		else
			return defaultValue;
	}

	public static long getPropertyAsLong(Object object, String propName) {
		return getPropertyAsLong(object, propName, 0);
	}

	public static long getPropertyAsLong(Object object, String propName,
			long defaultValue) {
		final Object result;
		try {
			result = getProperty(object, propName);
		} catch (Exception e) {
			return defaultValue;
		}
		if (result instanceof Number)
			return ((Number) result).longValue();
		else if (result instanceof String)
			return NumberUtils.toLong(result, 0);
		else
			return defaultValue;
	}

	public static boolean getPropertyAsBoolean(Object object, String propName) {
		return getPropertyAsBoolean(object, propName, false);
	}

	public static boolean getPropertyAsBoolean(Object object, String propName,
			boolean defaultValue) {
		final Object result;
		try {
			result = getProperty(object, propName);
		} catch (Exception e) {
			return defaultValue;
		}
		if (result instanceof Boolean)
			return ((Boolean) result).booleanValue();
		else if (result instanceof String)
			return "true".equalsIgnoreCase((String) result);
		else
			return defaultValue;
	}

}