/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/18
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * @author akima
 */
public class StringLoader {

	/**
	 *  
	 */
	public StringLoader(StreamFactory factory) {
		super();
		this.factory = factory;
	}

	private final StreamFactory factory;

	public String load(Object key) throws IOException {
		BufferedReader reader = new BufferedReader(new InputStreamReader(
				factory.newInput(key)));
		try {
			StringBuffer result = new StringBuffer();
			int c = reader.read();
			while (c > 0) {
				result.append((char) c);
				c = reader.read();
			}
			return result.toString();
		} finally {
			reader.close();
		}
	}

}