/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * @author Akima
 */
public class SimpleFileStreamFactory extends AbstractFileStreamFactory {

	/**
	 * Constructor for SimpleFileStreamLoader.
	 */
	public SimpleFileStreamFactory() {
		super();
	}

	/**
	 * @see org.asyrinx.brownie.core.io.sf.AbstractFileStreamFactory#toFilePath(java.lang.String)
	 */
	public String toFilePath(String fileName) {
		return fileName;
	}

	/**
	 */
	public InputStream newInput(String fileName) throws IOException {
		return new FileInputStream(fileName);
	}

	/**
	 */
	public OutputStream newOutput(String fileName) throws IOException {
		return new FileOutputStream(fileName);
	}

}