/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/08 23:39:47
 */
package org.asyrinx.brownie.core.collection.maptree;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * @author akima
 */
public interface MapTree {

    public Map getRoot();

    public Object get(MapTreeKey key);

    public Map getMap(MapTreeKey key);

    public void put(MapTreeKey key, Object value);

    /**
     * Object[] L[Ƃăf[^ɃANZXMapTree
     * 
     * @author akima
     */
    public static interface ArrayKey {
        public Map getRoot();

        public Object get(Object[] key);

        public Map getMap(Object[] key);

        public void put(Object[] key, Object value);
    }

    /**
     * Object L[Ƃăf[^ɃANZXMapTree
     * 
     * @author akima
     */
    public static interface ObjectKey {
        public Map getRoot();

        public Object get(Object key);

        public Map getMap(Object key);

        public void put(Object key, Object value);
    }

    /**
     * PropertiesIuWFNgɃf[^̓ǂݏC^tF[X
     * 
     * @author akima
     */
    public static interface PropertiesAccessible {
        public void saveTo(Properties dest);

        public void loadFrom(Properties source);
    }

    /**
     * PropertiesAccessibleC^tF[XT|[gC^tF[X
     * 
     * @author akima
     */
    public static interface PropertiesAccessibleSupport {
        public void saveToProperties(MapTree mapTree, Properties dest);

        public void loadFromProperties(MapTree mapTree, Properties source);
    }

    public static class Wrapper implements MapTree {
        public Wrapper(MapTree mapTree) {
            this.mapTree = mapTree;
        }

        protected final MapTree mapTree;

        public Object get(MapTreeKey key) {
            return mapTree.get(key);
        }

        public Map getMap(MapTreeKey key) {
            return mapTree.getMap(key);
        }

        public Map getRoot() {
            return mapTree.getRoot();
        }

        public void put(MapTreeKey key, Object value) {
            mapTree.put(key, value);
        }
    }

    public static final class Unmodifiable extends Wrapper {
        public Unmodifiable(MapTree mapTree) {
            super(mapTree);
        }

        public Map getRoot() {
            return Collections.unmodifiableMap(super.getRoot());
        }

        public Map getMap(MapTreeKey key) {
            return Collections.unmodifiableMap(super.getMap(key));
        }

        public void put(MapTreeKey key, Object value) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Indexed extends Wrapper {

        public Indexed(Unmodifiable unmodifiable, MapTreeKeyFactory keyFactory) {
            super(unmodifiable);
            this.keyFactory = keyFactory;
            initIndexes();
        }

        final Map valueIndex = new HashMap();

        final Map mapIndex = new HashMap();

        final MapTreeKeyFactory keyFactory;

        private void initIndexes() {
            final MapTreeVisitor visitor = new MapTreeVisitor(mapTree.getRoot()) {
                public void doOnLeaf(Object value) {
                    valueIndex.put(keyFactory.createKey(keyStack.toArray()), value);
                }

                public void doOnMap(Map map) {
                    mapIndex.put(keyFactory.createKey(keyStack.toArray()), map);
                }
            };
            visitor.execute();
        }

        public Object get(MapTreeKey key) {
            return valueIndex.get(key);
        }

        public Map getMap(MapTreeKey key) {
            return (Map) mapIndex.get(key);
        }

        public Map getValueIndex() {
            return Collections.unmodifiableMap(valueIndex);
        }

        public Map getMapIndex() {
            return Collections.unmodifiableMap(mapIndex);
        }
    }

}