/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/08 23:50:22
 */
package org.asyrinx.brownie.core.collection.maptree;

import java.util.Map;

import org.asyrinx.brownie.core.collection.MapFactory;
import org.asyrinx.brownie.core.lang.ArrayUtils;

/**
 * @author akima
 */
public class ArrayKeyHashMapTree implements MapTree.ArrayKey {

    /**
     *  
     */
    public ArrayKeyHashMapTree() {
        this(null);
    }

    /**
     *  
     */
    public ArrayKeyHashMapTree(Map root) {
        this(root, null);
    }

    /**
     * @param root
     * @param mapFactory
     */
    public ArrayKeyHashMapTree(Map root, MapFactory mapFactory) {
        super();
        this.mapFactory = (mapFactory != null) ? mapFactory : MapFactory.HashMap;
        this.root = (root != null) ? root : createMap();
    }

    protected final Map root;

    protected final MapFactory mapFactory;

    /**
     * L[ɂĎw肳ꂽ}邢͗tԂ܂B
     * 
     * @param key
     *               z̊evfc[̎}ƂĈ܂B
     * @return L[ɂĎw肳ꂽ݂ȂꍇɂnullԂ܂B
     */
    public Object get(Object[] key) {
        if (key == null || key.length == 0)
            return null;
        final Map map = (key.length == 1) ? root : getMap(ArrayUtils.subArray(key, 0, key.length - 1));
        return (map == null) ? null : map.get(key[key.length - 1]);
    }

    /**
     * @param key
     *               ̔z̊evfc[̎}ƂȂ܂B AL[ɂĎw肳ꂽ݂Ȃꍇɂ͎Iɍ쐬܂B
     * 
     * @param value
     *               ǉvfłB
     */
    public void put(Object[] key, Object value) {
        if (key == null || key.length == 0)
            return;
        final Map map = (key.length == 1) ? root : needMap(ArrayUtils.subArray(key, 0, key.length - 1));
        map.put(key[key.length - 1], value);
    }

    /**
     * MapTreeIuWFNgێ鍪MapIuWFNgԂ܂B
     * 
     * @return
     */
    public Map getRoot() {
        return root;
    }

    /**
     * L[ɂĎw肳ꂽ}MapIuWFNgԂ܂B
     * 
     * @param key
     *               z̊evfc[̎}ƂĈ܂B
     * @return
     */
    public Map getMap(Object[] key) {
        Map current = root;
        for (int i = 0; i < key.length; i++) {
            Object val = current.get(key[i]);
            if (val instanceof Map) {
                current = (Map) val;
            } else {
                return null;
            }
        }
        return current;
    }

    protected Map needMap(Object[] key) {
        Map current = root;
        for (int i = 0; i < key.length; i++) {
            Object val = current.get(key[i]);
            if (val instanceof Map) {
                current = (Map) val;
            } else {
                final Map newMap = createMap();
                current.put(key[i], newMap);
                current = newMap;
            }
        }
        return current;
    }

    protected Map createMap() {
        return mapFactory.createMap();
    }

}