/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.collection;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.asyrinx.brownie.core.collection.wrapper.MapWrapper;

/**
 * QƁiWeakReferencejŕێꂽlL[Ɗ֘Atĕێ}bvłB
 * put\bhkeyɊ֘AtꂽvaluéAQƈȊO̎QƂȂȂƁA
 * KxbWRNV̑ΏۂƂȂAvalueւ̎QƂnullɃNA܂B <br>
 * values\bhŎ擾łQƂ͏Ă邩mȂ̂ŁA valuesggpsƂĂ܂B
 * ֘AtꂽlɃANZXۂɂ́AgetK\bhgpĂB <br>
 * 
 * @author Akima
 */
public class WeakReferencedValueMap extends MapWrapper {

	public WeakReferencedValueMap() {
		this(new HashMap());
	}

	/**
	 * Constructor for WeakReferencedValueMap.
	 * 
	 * @param impl
	 */
	public WeakReferencedValueMap(Map impl) {
		super(impl);
	}

	/**
	 */
	public Object get(Object key) {
		Reference ref = (Reference) super.get(key);
		if (ref == null)
			return null;
		else
			return ref.get();
	}

	/**
	 */
	public Object put(Object key, Object value) {
		//if (get(key) == value)
		//	return null;
		return super.put(key, new WeakValue(value));
	}

	/**
	 */
	public Collection values() {
		throw new UnsupportedOperationException("͎̑gpł܂B");
	}

	static class WeakValue extends WeakReference {
		public WeakValue(Object referent) {
			super(referent);
		}

		public WeakValue(Object referent, ReferenceQueue q) {
			super(referent, q);
		}

		/**
		 * @see java.lang.Object#toString()
		 */
		public String toString() {
			return String.valueOf(super.get());
		}

	}
}