/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.tapestry.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IPage;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.html.Shell;
import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.tapestry.util.ClassMatch;
import org.asyrinx.brownie.tapestry.util.IdMatch;

public class ComponentUtils {
    private static Log log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.asyrinx.brownie.tapestry.util.ComponentUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    private ComponentUtils() {
    }

    public static IComponent getTopContainer(IComponent target) {
        if (target == null) {
            return null;
        }
        if (target.getContainer() != null) {
            return ComponentUtils.getTopContainer(target.getContainer());
        }
        return target;
    }

    public static IComponent lookFor(IComponent target, Predicate filter) {
        if (target == null) {
            return null;
        }
        Map targetComponents = target.getComponents();
        Iterator iterator = targetComponents.values().iterator();
        while (iterator.hasNext()) {
            Object component = iterator.next();
            if (!(component instanceof IComponent) || !filter.evaluate(component)) continue;
            return (IComponent)component;
        }
        return null;
    }

    public static IComponent lookForByClass(IComponent target, Class class1) {
        return ComponentUtils.lookFor(target, new ClassMatch(class1));
    }

    public static IComponent lookForById(IComponent target, String componentId) {
        return ComponentUtils.lookFor(target, new IdMatch(componentId));
    }

    public static IComponent searchBottom(IComponent target, Predicate filter) {
        if (target == null) {
            return null;
        }
        IComponent result = ComponentUtils.lookFor(target, filter);
        if (result != null) {
            return result;
        }
        Iterator iterator = target.getComponents().values().iterator();
        while (iterator.hasNext()) {
            IComponent subcomponent = (IComponent)iterator.next();
            result = ComponentUtils.searchBottom(subcomponent, filter);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static IComponent searchBottomById(IComponent target, String componentId) {
        return ComponentUtils.searchBottom(target, new IdMatch(componentId));
    }

    public static IComponent searchBottomByClass(IComponent target, Class clazz) {
        return ComponentUtils.searchBottom(target, new ClassMatch(clazz));
    }

    public static IComponent searchUpper(IComponent target, Predicate filter) {
        if (target == null) {
            return null;
        }
        IComponent parent = target.getContainer();
        if (parent == null) {
            return null;
        }
        if (filter.evaluate((Object)parent)) {
            return parent;
        }
        return ComponentUtils.searchUpper(parent, filter);
    }

    public static IComponent searchUpperById(IComponent target, String componentId) {
        return ComponentUtils.searchUpper(target, new IdMatch(componentId));
    }

    public static IComponent searchUpperByClass(IComponent target, Class clazz) {
        return ComponentUtils.searchUpper(target, new ClassMatch(clazz));
    }

    public static String getElementId(IComponent client, String id) {
        IFormComponent formComponent;
        IPage page = client.getPage();
        IComponent component = ComponentUtils.searchBottomById((IComponent)page, id);
        IFormComponent iFormComponent = formComponent = component instanceof IFormComponent ? (IFormComponent)component : null;
        if (formComponent == null) {
            return null;
        }
        IForm form = formComponent.getForm();
        return form.getElementId(formComponent);
    }

    public static String getNameOnForm(IComponent component) {
        if (component instanceof IFormComponent) {
            return ((IFormComponent)component).getName();
        }
        return null;
    }

    public static void addStylesheet(IComponent component, String assetName) {
        ComponentUtils.addStylesheet(component, component.getAsset(assetName));
    }

    public static void addStylesheet(IComponent component, IAsset asset) {
        IComponent iComponent = ComponentUtils.getTopContainer(component);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.apache.tapestry.html.Shell");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Shell shell = (Shell)ComponentUtils.searchBottomByClass(iComponent, clazz);
        ComponentUtils.addStylesheet(shell, asset);
    }

    /*
     * WARNING - void declaration
     */
    public static void addStylesheet(Shell shell, IAsset asset) {
        void var3_3;
        Collection newStylesheets;
        if (shell == null) {
            log.warn((Object)"failed to addStylesheet because Shell is null");
            return;
        }
        Object original = shell.getStylesheets();
        if (original instanceof Object[]) {
            newStylesheets = ArrayUtils.toArrayList((Object[])original);
        } else if (original instanceof Collection) {
            newStylesheets = (Collection)original;
        } else {
            return;
        }
        var3_3.add(asset);
    }
}

