/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.tapestry.components.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.asset.PrivateAsset;
import org.apache.tapestry.html.Body;
import org.apache.tapestry.resource.ClasspathResourceLocation;
import org.apache.tapestry.util.IdAllocator;
import org.asyrinx.brownie.tapestry.script.IFinalizableScriptProcessor;

public abstract class ExBody
extends Body
implements IFinalizableScriptProcessor {
    private StringBuffer _initializationScript;
    private StringBuffer _finalizationScript;
    private IMarkupWriter _outerWriter;
    private StringBuffer _bodyScript;
    private StringBuffer _imageInitializations;
    private Map _imageMap;
    private List _externalScripts;
    private IdAllocator _idAllocator;
    private static final String ATTRIBUTE_NAME = "org.apache.tapestry.active.Body";

    public String getPreloadedImageReference(String URL2) {
        String reference;
        if (this._imageMap == null) {
            this._imageMap = new HashMap();
        }
        if ((reference = (String)this._imageMap.get(URL2)) == null) {
            int count = this._imageMap.size();
            String varName = "tapestry_preload[" + count + "]";
            reference = String.valueOf(varName) + ".src";
            if (this._imageInitializations == null) {
                this._imageInitializations = new StringBuffer();
            }
            this._imageInitializations.append("  ");
            this._imageInitializations.append(varName);
            this._imageInitializations.append(" = new Image();\n");
            this._imageInitializations.append("  ");
            this._imageInitializations.append(reference);
            this._imageInitializations.append(" = \"");
            this._imageInitializations.append(URL2);
            this._imageInitializations.append("\";\n");
            this._imageMap.put(URL2, reference);
        }
        return reference;
    }

    public void addInitializationScript(String script) {
        if (this._initializationScript == null) {
            this._initializationScript = new StringBuffer(script.length() + 1);
        }
        this._initializationScript.append(script);
        this._initializationScript.append('\n');
    }

    public void addFinalizationScript(String script) {
        if (this._finalizationScript == null) {
            this._finalizationScript = new StringBuffer(script.length() + 1);
        }
        this._finalizationScript.append(script);
        this._finalizationScript.append('\n');
    }

    public void addBodyScript(String script) {
        if (this._bodyScript == null) {
            this._bodyScript = new StringBuffer(script.length());
        }
        this._bodyScript.append(script);
    }

    public void addExternalScript(IResourceLocation scriptLocation) {
        if (this._externalScripts == null) {
            this._externalScripts = new ArrayList();
        }
        if (this._externalScripts.contains(scriptLocation)) {
            return;
        }
        if (!(scriptLocation instanceof ClasspathResourceLocation)) {
            throw new ApplicationRuntimeException("Body.include-classpath-script-only", (Object)this, null, null);
        }
        this._externalScripts.add(scriptLocation);
    }

    private void writeExternalScripts(IMarkupWriter writer) {
        int count = Tapestry.size((Collection)this._externalScripts);
        int i = 0;
        while (i < count) {
            ClasspathResourceLocation scriptLocation = (ClasspathResourceLocation)this._externalScripts.get(i);
            PrivateAsset asset = new PrivateAsset(scriptLocation, null);
            String url = asset.buildURL(this.getPage().getRequestCycle());
            writer.begin("script");
            writer.attribute("language", "JavaScript");
            writer.attribute("type", "text/javascript");
            writer.attribute("src", url);
            writer.end();
            writer.println();
            ++i;
        }
    }

    public static Body get(IRequestCycle cycle) {
        return (Body)cycle.getAttribute(ATTRIBUTE_NAME);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.getAttribute(ATTRIBUTE_NAME) != null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage((String)"Body.may-not-nest"), (Object)this, null, null);
        }
        cycle.setAttribute(ATTRIBUTE_NAME, (Object)this);
        this._outerWriter = writer;
        IMarkupWriter nested = writer.getNestedWriter();
        this.renderBody(nested, cycle);
        writer.println();
        writer.begin(this.getElement());
        this.renderInformalParameters(writer, cycle);
        writer.println();
        this.writeScript();
        nested.close();
        writer.end();
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        super.cleanupAfterRender(cycle);
        if (this._idAllocator != null) {
            this._idAllocator.clear();
        }
        if (this._imageMap != null) {
            this._imageMap.clear();
        }
        if (this._externalScripts != null) {
            this._externalScripts.clear();
        }
        if (this._initializationScript != null) {
            this._initializationScript.setLength(0);
        }
        if (this._finalizationScript != null) {
            this._finalizationScript.setLength(0);
        }
        if (this._imageInitializations != null) {
            this._imageInitializations.setLength(0);
        }
        if (this._bodyScript != null) {
            this._bodyScript.setLength(0);
        }
        this._outerWriter = null;
        this._outerWriter = null;
    }

    protected void writeScript() {
        if (!Tapestry.isEmpty((Collection)this._externalScripts)) {
            this.writeExternalScripts(this._outerWriter);
        }
        if (!(this.any(this._initializationScript) || this.any(this._finalizationScript) || this.any(this._bodyScript) || this.any(this._imageInitializations))) {
            return;
        }
        this._outerWriter.begin("script");
        this._outerWriter.attribute("language", "JavaScript");
        this._outerWriter.printRaw("<!--");
        if (this.any(this._imageInitializations)) {
            this._outerWriter.printRaw("\n\nvar tapestry_preload = new Array();\n");
            this._outerWriter.printRaw("if (document.images)\n");
            this._outerWriter.printRaw("{\n");
            this._outerWriter.printRaw(this._imageInitializations.toString());
            this._outerWriter.printRaw("}\n");
        }
        if (this.any(this._bodyScript)) {
            this._outerWriter.printRaw("\n\n");
            this._outerWriter.printRaw(this._bodyScript.toString());
        }
        if (this.any(this._initializationScript)) {
            this._outerWriter.printRaw("\n\nwindow.onload = function ()\n{\n");
            this._outerWriter.printRaw(this._initializationScript.toString());
            this._outerWriter.printRaw("}");
        }
        if (this.any(this._finalizationScript)) {
            this._outerWriter.printRaw("\n\nwindow.onunload = function ()\n{\n");
            this._outerWriter.printRaw(this._finalizationScript.toString());
            this._outerWriter.printRaw("}");
        }
        this._outerWriter.printRaw("\n\n// -->");
        this._outerWriter.end();
    }

    private boolean any(StringBuffer buffer) {
        if (buffer == null) {
            return false;
        }
        return buffer.length() > 0;
    }

    public abstract String getElement();

    public abstract void setElement(String var1);
}

