/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.swing.content;

import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.asyrinx.brownie.swing.content.WindowContent;

public class ContentFrame
extends JFrame {
    protected final Component content;

    public ContentFrame(Component content, String title) throws HeadlessException {
        super(title);
        this.content = content;
        this.intiPane();
    }

    protected void intiPane() {
        if (this.content instanceof Container) {
            this.setContentPane((Container)this.content);
        } else {
            JPanel panel = new JPanel();
            panel.add(this.content);
            this.setContentPane(panel);
        }
    }

    public void show() {
        this.invokeBeforeShow();
        super.show();
        this.invokeAfterShow();
    }

    protected void invokeBeforeShow() {
        if (this.content instanceof WindowContent) {
            ((WindowContent)((Object)this.content)).beforeShow();
        }
    }

    protected void invokeAfterShow() {
        if (this.content instanceof WindowContent) {
            ((WindowContent)((Object)this.content)).afterShow();
        }
    }

    public void hide() {
        this.invokeBeforeHide();
        super.hide();
        this.invokeAfterHide();
    }

    protected void invokeBeforeHide() {
        if (this.content instanceof WindowContent) {
            ((WindowContent)((Object)this.content)).beforeHide();
        }
    }

    protected void invokeAfterHide() {
        if (this.content instanceof WindowContent) {
            ((WindowContent)((Object)this.content)).afterHide();
        }
    }
}

