/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.util;

import org.asyrinx.brownie.core.lang.NumberUtils;

final class SortType {
    private final int nullIndex;
    private final int numIndex;
    private final int strIndex;

    SortType(int nullIndex, int numIndex, int strIndex) {
        this.nullIndex = nullIndex;
        this.numIndex = numIndex;
        this.strIndex = strIndex;
    }

    public int compare(Object o1, Object o2, int numSortValue, int strSortValue) {
        Number n2;
        Number n1 = NumberUtils.isNumber(o1) ? (Number)NumberUtils.toNumber(o1) : (Number)null;
        Number number = n2 = NumberUtils.isNumber(o2) ? (Number)NumberUtils.toNumber(o2) : (Number)null;
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return this.compareToNull(n2);
        }
        if (o2 == null) {
            return -this.compareToNull(n1);
        }
        if (n1 != null && n2 != null) {
            return n1.doubleValue() == n2.doubleValue() ? 0 : (n1.doubleValue() > n2.doubleValue() ? numSortValue : -numSortValue);
        }
        if (n1 != null) {
            return this.compareNumAndStr();
        }
        if (n2 != null) {
            return -this.compareNumAndStr();
        }
        return o1.toString().compareTo(o2.toString()) * strSortValue;
    }

    private int compareToNull(Number num) {
        switch (this.nullIndex) {
            case 1: {
                return -1;
            }
            case 2: {
                if (num == null) {
                    return this.nullIndex < this.strIndex ? -1 : 1;
                }
                return this.nullIndex < this.numIndex ? -1 : 1;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    private int compareNumAndStr() {
        return this.numIndex < this.strIndex ? -1 : 1;
    }
}

