/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.asyrinx.brownie.core.csv.SVParser;
import org.asyrinx.brownie.core.csv.SVParserListener;
import org.asyrinx.brownie.core.lang.StringUtils;

public class SimpleSVParser
implements SVParser {
    private SVParserListener listener;
    private String delimeter = String.valueOf(',');

    public void parse(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String line = bufferedReader.readLine();
        ArrayList dest = new ArrayList();
        while (line != null) {
            StringUtils.tokenize(dest, line, this.delimeter);
            this.listener.onLine(dest);
            line = bufferedReader.readLine();
            dest.clear();
        }
    }

    public String getDelimeter() {
        return this.delimeter;
    }

    public void setDelimeter(String string) {
        this.delimeter = string;
    }

    public void addListener(SVParserListener l) {
        this.listener = l;
    }

    public void removeListener(SVParserListener l) {
        if (this.listener == l) {
            this.listener = null;
        }
    }
}

