/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.texen.ant.TexenTask;
import org.asyrinx.brownie.core.lang.ClassUtils;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.command.rdb2java.standard.Rdb2JavaBuilder;
import org.asyrinx.joey.gen.hibernate.HibernateUtils;
import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.xml.XmlToRdb;
import org.asyrinx.joey.gen.task.VelocityHelper;
import org.xml.sax.SAXException;

public class DataModelTask
extends TexenTask {
    protected String xmlFile;
    protected List filesets = new ArrayList();
    protected Context context;
    private String builderClassName = "org.asyrinx.joey.gen.command.rdb2java.standard.BasicBuilder";
    static /* synthetic */ Class class$0;

    public String getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(String xmlFile) {
        this.xmlFile = this.project.resolveFile(xmlFile).toString();
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public Context initControlContext() throws Exception {
        return this.loadModels();
    }

    private Context loadModels() throws IOException, SAXException, InstantiationException {
        if (this.xmlFile == null && this.filesets.isEmpty()) {
            throw new BuildException("You must specify an XML schema or fileset of XML schemas!");
        }
        Databases databases = new Databases();
        if (this.xmlFile != null) {
            databases.getDatabases().add(this.loadModelXmlFile(this.xmlFile));
        } else {
            int i = 0;
            while (i < this.filesets.size()) {
                FileSet fs = (FileSet)this.filesets.get(i);
                DirectoryScanner ds = fs.getDirectoryScanner(this.project);
                File srcDir = fs.getDir(this.project);
                String[] dataModelFiles = ds.getIncludedFiles();
                int j = 0;
                while (j < dataModelFiles.length) {
                    File f = new File(srcDir, dataModelFiles[j]);
                    Databases loaded = this.loadModelXmlFile(f.toString());
                    databases.appendDatabases(loaded);
                    ++j;
                }
                ++i;
            }
        }
        Rdb2JavaBuilder builder = this.newBuilder();
        AppDomain domain = builder.execute(databases);
        this.context = new VelocityContext();
        this.context.put("databases", (Object)databases);
        this.context.put("domain", (Object)domain);
        this.context.put("builder", (Object)builder);
        this.context.put("helper", (Object)new VelocityHelper());
        this.context.put("stringUtils", (Object)new StringUtils());
        this.context.put("hibernateUtils", (Object)new HibernateUtils());
        return this.context;
    }

    protected Databases loadModelXmlFile(String filename) throws IOException, SAXException {
        XmlToRdb xmlToRdb = new XmlToRdb();
        xmlToRdb.setDebug("true".equals(this.getContextProperties().getString("schemaDebug")));
        return xmlToRdb.load(filename);
    }

    public void setContextProperties(String file) {
        String newKey;
        String key;
        super.setContextProperties(file);
        Hashtable env = super.getProject().getProperties();
        Iterator i = env.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            if (!key.startsWith("joey-gen.")) continue;
            newKey = this.toVelocityKey(key.substring("joey-gen.".length()));
            this.contextProperties.setProperty(newKey, env.get(key));
            System.out.println("joey-gen property available: " + newKey + ":" + env.get(key));
        }
        i = env.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            if (!key.startsWith("proj.")) continue;
            newKey = this.toVelocityKey(key);
            this.contextProperties.setProperty(newKey, env.get(key));
            System.out.println("project property available: " + newKey + ":" + env.get(key));
        }
    }

    private String toVelocityKey(String newKey) {
        int j = newKey.indexOf(".");
        while (j != -1) {
            newKey = String.valueOf(newKey.substring(0, j)) + StringUtils.capitalize((String)newKey.substring(j + 1));
            j = newKey.indexOf(".");
        }
        return newKey;
    }

    public String getBuilderClassName() {
        return this.builderClassName;
    }

    public void setBuilderClassName(String builderClassName) {
        this.builderClassName = builderClassName;
    }

    protected Rdb2JavaBuilder newBuilder() throws InstantiationException {
        String string = this.getBuilderClassName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.asyrinx.joey.gen.command.rdb2java.standard.Rdb2JavaBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Rdb2JavaBuilder)ClassUtils.newObject((String)string, (Class)clazz);
    }
}

