/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model.rdb;

import java.util.Iterator;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.RdbEnumerationSet;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.TableSet;

public class Database
extends Element {
    private final TableSet tables = new TableSet(this);
    private final RdbEnumerationSet enumerations = new RdbEnumerationSet(this);

    public Database() {
    }

    public Database(Databases parent, String name) {
        super(parent, name);
    }

    public Databases getParent() {
        return (Databases)super.getParentElement();
    }

    public void add(Element element) {
        if (element instanceof Table) {
            this.tables.add((Table)element);
        } else if (element instanceof RdbEnumeration) {
            this.enumerations.add((RdbEnumeration)element);
        } else {
            super.add(element);
        }
    }

    public TableSet getTables() {
        return this.tables;
    }

    public RdbEnumerationSet getEnumerations() {
        return this.enumerations;
    }

    public void moveTables(Database dest) {
        Iterator i = this.tables.iterator();
        while (i.hasNext()) {
            Table table = (Table)i.next();
            dest.getTables().add(table);
        }
    }

    public void moveEnumerations(Database dest) {
        Iterator i = this.enumerations.iterator();
        while (i.hasNext()) {
            RdbEnumeration enumeration = (RdbEnumeration)i.next();
            dest.getEnumerations().add(enumeration);
        }
    }

    public Column getColumn(String columnName) {
        String[] nameParts = StringUtils.tokenizeToArray((String)columnName, (String)".");
        if (nameParts.length == 2) {
            return this.getColumn(nameParts[0], nameParts[1]);
        }
        if (nameParts.length == 3 && this.getParent() != null) {
            return this.getParent().getColumn(columnName);
        }
        return null;
    }

    public Column getColumn(String tableName, String columnName) {
        Table table = this.getTables().getTable(tableName);
        return table == null ? null : table.getColumns().getColumn(columnName);
    }
}

