/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model.java.classes;

import org.asyrinx.joey.gen.model.java.Type;
import org.asyrinx.joey.gen.model.java.TypeCategory;
import org.asyrinx.joey.gen.model.java.classes.EmbeddedClass;
import org.asyrinx.joey.gen.model.java.classes.PrimitiveWrapper;

public abstract class PrimitiveType
extends EmbeddedClass {
    public static final String PACKAGE = "java.lang";
    public static final PrimitiveType BOOLEAN = new PrimitiveType("boolean", TypeCategory.BOOLEAN){

        public Type toClass() {
            return PrimitiveWrapper.BOOLEAN;
        }
    };
    public static final PrimitiveType CHAR = new PrimitiveType("char", TypeCategory.STRING){

        public Type toClass() {
            return PrimitiveWrapper.CHARACTER;
        }
    };
    public static final PrimitiveType BYTE = new PrimitiveType("byte", TypeCategory.NUMBER){

        public Type toClass() {
            return PrimitiveWrapper.BYTE;
        }
    };
    public static final PrimitiveType SHORT = new PrimitiveType("short", TypeCategory.NUMBER){

        public Type toClass() {
            return PrimitiveWrapper.SHORT;
        }
    };
    public static final PrimitiveType INT = new PrimitiveType("int", TypeCategory.NUMBER){

        public Type toClass() {
            return PrimitiveWrapper.INTEGER;
        }
    };
    public static final PrimitiveType LONG = new PrimitiveType("long", TypeCategory.NUMBER){

        public Type toClass() {
            return PrimitiveWrapper.LONG;
        }
    };
    public static final PrimitiveType FLOAT = new PrimitiveType("float", TypeCategory.NUMBER){

        public Type toClass() {
            return PrimitiveWrapper.FLOAT;
        }
    };
    public static final PrimitiveType DOUBLE = new PrimitiveType("double", TypeCategory.NUMBER){

        public Type toClass() {
            return PrimitiveWrapper.DOUBLE;
        }
    };

    public PrimitiveType(String className, TypeCategory category) {
        super(PACKAGE, className, category);
    }

    public String getFqn() {
        return this.getName();
    }

    public String getPackage() {
        return null;
    }

    public boolean isPrimitive() {
        return true;
    }

    public Type toPrimitive() {
        return this;
    }
}

