/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.model.Element;

public abstract class ElementSet
extends Element {
    protected final List elementList = new ArrayList();

    public ElementSet(String name) {
        this(null, name, null);
    }

    public ElementSet(Element parent) {
        this(parent, null, null);
    }

    public ElementSet(Element parent, String name) {
        this(parent, name, null);
    }

    public ElementSet(Element parent, String name, String label) {
        super(parent, name, label);
    }

    public abstract boolean isEntity();

    public void add(Element element) {
        if (element == null) {
            throw new NullPointerException("element must not be null");
        }
        if (!this.elementList.contains(element)) {
            this.elementList.add(element);
        }
        if (element.getParentElement() != this) {
            element.setParentElement(this.isEntity() ? this : this.getParentElement());
        }
    }

    public final void clear() {
        this.elementList.clear();
    }

    public final boolean contains(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return false;
        }
        int i = 0;
        while (i < this.elementList.size()) {
            Element element = (Element)this.elementList.get(i);
            if (name.equals(element.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean contains(Element element) {
        return this.elementList.contains(element);
    }

    protected Element getElement(int index) {
        return index < 0 ? null : (Element)this.elementList.get(index);
    }

    protected Element getElement(String name) {
        return this.getElement(this.indexOf(name));
    }

    public final int indexOf(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return -1;
        }
        int i = 0;
        while (i < this.elementList.size()) {
            Element element = (Element)this.elementList.get(i);
            if (name.equals(element.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final int indexOf(Element element) {
        return this.elementList.indexOf(element);
    }

    public final boolean isEmpty() {
        return this.elementList.isEmpty();
    }

    public final Iterator iterator() {
        return this.elementList.iterator();
    }

    protected Element removeElement(String name) {
        int index = this.indexOf(name);
        return index < 0 ? null : (Element)this.elementList.remove(index);
    }

    public final int size() {
        return this.elementList.size();
    }

    public List toList() {
        return new ArrayList(this.elementList);
    }
}

