/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.jdbc;

import java.util.HashMap;
import org.asyrinx.brownie.core.collection.IntegerKeyMap;
import org.asyrinx.brownie.core.collection.MapUtils;
import org.asyrinx.joey.gen.jdbc.IntValueMap;

public class JdbcUtils {
    public static final int UNKNOWN_TYPE = 99999;
    static final IntegerKeyMap type2name = MapUtils.toIntegerKeyMap(new HashMap());
    static final IntValueMap name2type = new IntValueMap(99999);

    static {
        JdbcUtils.add(16, "BOOLEAN");
        JdbcUtils.add(-7, "BIT");
        JdbcUtils.add(-6, "TINYINT");
        JdbcUtils.add(5, "SMALLINT");
        JdbcUtils.add(4, "INTEGER");
        JdbcUtils.add(-5, "BIGINT");
        JdbcUtils.add(6, "FLOAT");
        JdbcUtils.add(7, "REAL");
        JdbcUtils.add(8, "DOUBLE");
        JdbcUtils.add(2, "NUMERIC");
        JdbcUtils.add(3, "DECIMAL");
        JdbcUtils.add(1, "CHAR");
        JdbcUtils.add(12, "VARCHAR");
        JdbcUtils.add(-1, "LONGVARCHAR");
        JdbcUtils.add(91, "DATE");
        JdbcUtils.add(92, "TIME");
        JdbcUtils.add(93, "TIMESTAMP");
        JdbcUtils.add(-2, "BINARY");
        JdbcUtils.add(-3, "VARBINARY");
        JdbcUtils.add(-4, "LONGVARBINARY");
        JdbcUtils.add(0, "NULL");
        JdbcUtils.add(1111, "OTHER");
        JdbcUtils.add(2000, "JAVA_OBJECT");
        JdbcUtils.add(2001, "DISTINCT");
        JdbcUtils.add(2002, "STRUCT");
        JdbcUtils.add(2003, "ARRAY");
        JdbcUtils.add(2004, "BLOB");
        JdbcUtils.add(2005, "CLOB");
        JdbcUtils.add(2006, "REF");
        JdbcUtils.add(70, "DATALINK");
        JdbcUtils.add(16, "BOOLEAN");
    }

    private static final void add(int jdbcType, String jdbcTypeName) {
        type2name.put(jdbcType, (Object)jdbcTypeName);
        name2type.put(jdbcTypeName, jdbcType);
    }

    public static String toJdbcTypeName(int jdbcType) {
        return (String)type2name.get(jdbcType);
    }

    public static int toJdbcType(String jdbcTypeName) {
        return name2type.getAsInt(jdbcTypeName);
    }
}

