/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.rdb2java.standard;

import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.command.rdb.CopyPackageNames;
import org.asyrinx.joey.gen.command.rdb2java.standard.PackagingStrategy;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.JavaEnumeration;
import org.asyrinx.joey.gen.model.java.PackageType;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.Table;

public class BasicPackaging
implements PackagingStrategy {
    private CopyPackageNames copyPackageNames = new CopyPackageNames();
    public static final String PACKAGE_TEMPLATE_SYMBOL = "${packageType}";

    public String toPackageName(RdbEnumeration rdbEnumeration) {
        return this.copyPackageNames.toPackageName(rdbEnumeration);
    }

    public String getPackageName(Element element) {
        return this.copyPackageNames.getPackage(element.getOptions());
    }

    public String toPackageName(Table table) {
        return this.copyPackageNames.toPackageName(table);
    }

    public void preparePackageNames(Entity entity) {
        String template = entity.getPackageTemplate();
        Iterator i = PackageType.getElements().iterator();
        while (i.hasNext()) {
            PackageType packageType = (PackageType)((Object)i.next());
            entity.setPackage(packageType.getName(), this.genPackageName(template, packageType));
        }
    }

    private String genPackageName(String template, PackageType packageType) {
        String packageName = StringUtils.replace((String)template, (String)PACKAGE_TEMPLATE_SYMBOL, (String)packageType.getName());
        return packageName;
    }

    public void preparePackageName(JavaEnumeration javaEnumeration) {
        javaEnumeration.setPackageName(this.genPackageName(javaEnumeration.getPackageName(), PackageType.ENTITY));
    }
}

