/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.rdb;

import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.command.rdb.RdbCommand;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyType;
import org.asyrinx.joey.gen.model.rdb.Table;

public class ExtendsToFk
extends RdbCommand {
    public void visit(Table table) {
        if (StringUtils.isEmpty((String)table.getExtends())) {
            return;
        }
        Table extendsTable = table.getExtendsTable();
        if (extendsTable == null) {
            this.addError(table, "could not find table'" + table.getExtends() + "'");
        }
        ForeignKey foreignKey = new ForeignKey(table, extendsTable.getName());
        foreignKey.setType(ForeignKeyType.EXTENDS);
        this.log(foreignKey, "create FK  ");
        if (table.hasPrimaryKey()) {
            this.log.warn((Object)("table '" + table.getName() + "' has primary key. " + "if you use hibernate, don't set primary key because primary key will be automatically generated."));
        }
        Iterator i = extendsTable.getPkColumns();
        while (i.hasNext()) {
            Column foreignColumn = (Column)i.next();
            Column localColumn = new Column(table, foreignColumn.getName(), foreignColumn.getType(), foreignColumn.getSize(), foreignColumn.isRequired(), !table.hasPrimaryKey(), foreignColumn.getDefaultValue());
            localColumn.setExtended(true);
            this.log(localColumn, "create Col ");
            ForeignKeyEntry foreignKeyEntry = new ForeignKeyEntry(foreignKey, localColumn.getName(), foreignColumn.getName());
            this.log(foreignKeyEntry, "create FKEntry");
        }
    }
}

