/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.rdb;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.command.rdb.RdbCommand;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.Table;

public class CopyPackageNames
extends RdbCommand {
    public void visit(Table table) {
        table.getOptions().put("javaPackage", this.toPackageName(table));
    }

    public void visit(RdbEnumeration enumeration) {
        enumeration.getOptions().put("javaPackage", this.toPackageName(enumeration));
    }

    public String getPackage(Map options) {
        Object result = options.get("javaPackage");
        return result != null ? result.toString() : null;
    }

    public String toPackageName(RdbEnumeration rdbEnumeration) {
        String result = this.toPackageNameImpl(rdbEnumeration);
        if (result != null) {
            return result;
        }
        return rdbEnumeration.getParent() == null ? null : rdbEnumeration.getParent().getName();
    }

    public String toPackageName(Table table) {
        String result = this.toPackageNameImpl(table);
        if (result != null) {
            return result;
        }
        return table.getParent() == null ? null : table.getParent().getName();
    }

    protected String toPackageNameImpl(Element element) {
        String result = this.getPackage(element.getOptions());
        if (!StringUtils.isEmpty((String)result)) {
            return result;
        }
        if (element.getParentElement() != null) {
            return this.toPackageNameImpl(element.getParentElement());
        }
        return null;
    }
}

