/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.rdb;

import org.asyrinx.joey.gen.command.rdb.RdbCommand;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.ColumnType;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;

public class CheckFkColumnType
extends RdbCommand {
    public void visit(ForeignKeyEntry entry) {
        ColumnType type;
        Column foreignColumn;
        Column localColumn = entry.getLocalColumn();
        if (localColumn == null) {
            this.addError(entry, "local column not found. " + entry.getLocal());
        }
        if ((foreignColumn = entry.getForeignColumn()) == null) {
            this.addError(entry, "foreign column not found. " + entry.getForeign());
        }
        if (!localColumn.getType().equals(foreignColumn.getType())) {
            this.addError(entry, "column type different between " + localColumn.getType() + "(" + localColumn.getFullName() + ") and " + foreignColumn.getType() + "(" + foreignColumn.getFullName() + ")");
        }
        if ((type = ColumnType.get(localColumn.getType())) == null) {
            this.addError(localColumn, "type not found. " + localColumn.getType());
        }
        if (type.isRequiredSize() && localColumn.getSize() != foreignColumn.getSize()) {
            this.addError(entry, "column size different between " + localColumn.getSize() + "(" + localColumn.getFullName() + ") and " + foreignColumn.getSize() + "(" + foreignColumn.getFullName() + ")");
        }
    }
}

