/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.om.hibernate;

import java.util.Collection;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.expression.Expression;
import org.asyrinx.brownie.core.sql.Operator;

class CriteriaUtils {
    CriteriaUtils() {
    }

    public static Criterion toExpression(Operator operator, Object targetValue, Object value) {
        if (operator == null) {
            throw new UnsupportedOperationException("No operator to translate to Expression");
        }
        if (operator == Operator.AND) {
            if (targetValue instanceof Criterion && value instanceof Criterion) {
                return Expression.and((Criterion)((Criterion)targetValue), (Criterion)((Criterion)value));
            }
            throw new UnsupportedOperationException("target and value must be Criteria.");
        }
        if (operator == Operator.EQUAL || operator == Operator.EQUAL2) {
            return Expression.eq((String)CriteriaUtils.toString(targetValue), (Object)value);
        }
        if (operator == Operator.IN) {
            if (value instanceof Collection) {
                return Expression.in((String)CriteriaUtils.toString(targetValue), (Collection)((Collection)value));
            }
            if (value.getClass().isArray()) {
                if (!value.getClass().getComponentType().isPrimitive()) {
                    return Expression.in((String)CriteriaUtils.toString(targetValue), (Object[])((Object[])value));
                }
                throw new UnsupportedOperationException("value must be Collection or array of Object.");
            }
            throw new UnsupportedOperationException("value must be Collection or array of Object.");
        }
        if (operator == Operator.GREATER_EQUAL || operator == Operator.GREATER_EQUAL2) {
            return Expression.ge((String)CriteriaUtils.toString(targetValue), (Object)value);
        }
        if (operator == Operator.GREATER_THAN) {
            return Expression.gt((String)CriteriaUtils.toString(targetValue), (Object)value);
        }
        if (operator == Operator.LIKE) {
            return Expression.like((String)CriteriaUtils.toString(targetValue), (Object)value);
        }
        if (operator == Operator.NOT_EQUAL || operator == Operator.NOT_EQUAL2) {
            return Expression.not((Criterion)CriteriaUtils.toExpression(Operator.EQUAL, CriteriaUtils.toString(targetValue), value));
        }
        if (operator == Operator.NOT_IN) {
            return Expression.not((Criterion)CriteriaUtils.toExpression(Operator.IN, CriteriaUtils.toString(targetValue), value));
        }
        if (operator == Operator.OR) {
            if (targetValue instanceof Criterion && value instanceof Criterion) {
                return Expression.or((Criterion)((Criterion)targetValue), (Criterion)((Criterion)value));
            }
            throw new UnsupportedOperationException("target and value must be Criteria.");
        }
        if (operator == Operator.LESS_EQUAL || operator == Operator.LESS_EQUAL2) {
            return Expression.le((String)CriteriaUtils.toString(targetValue), (Object)value);
        }
        if (operator == Operator.LESS_THAN) {
            return Expression.lt((String)CriteriaUtils.toString(targetValue), (Object)value);
        }
        throw new UnsupportedOperationException("Unknown operator to translate to Expression. '" + operator.toString() + "'");
    }

    private static String toString(Object targetValue) {
        if (!(targetValue instanceof String)) {
            throw new UnsupportedOperationException("target must be String.");
        }
        return (String)targetValue;
    }
}

