/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gui.swing.listview;

import java.awt.event.ActionEvent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.asyrinx.joey.gui.swing.EntityListViewTable;
import org.asyrinx.joey.gui.swing.listview.AbstractEntityListViewTableAction;
import org.asyrinx.joey.gui.swing.listview.EntityListViewTableAction;
import org.asyrinx.joey.gui.swing.listview.EntityListViewTableActionKit;
import org.asyrinx.joey.gui.swing.listview.ListViewMenuItem;

public class DefaultEntityListViewTableActionKit
implements EntityListViewTableActionKit {
    public static final EntityListViewTableAction SELECT = new Select();
    public static final EntityListViewTableAction SHOW_DETAIL = new ShowDetail();
    public static final EntityListViewTableAction INSERT = new Insert();
    public static final EntityListViewTableAction DELETE = new Delete();
    public static final EntityListViewTableAction REFRESH = new Refresh();
    private static final EntityListViewTableAction[] DEFAULT_ACTIONS = new EntityListViewTableAction[]{SELECT, SHOW_DETAIL, INSERT, DELETE, REFRESH};

    public EntityListViewTableAction[] getActions(EntityListViewTable listViewTable) {
        return DEFAULT_ACTIONS;
    }

    public void preparePopupMenu(EntityListViewTable listViewTable, JPopupMenu popupMenu) {
        EntityListViewTableAction[] actions = this.getActions(listViewTable);
        int i = 0;
        while (i < actions.length) {
            EntityListViewTableAction action = actions[i];
            if (action.isOnPopupMenu()) {
                popupMenu.add(new ListViewMenuItem(listViewTable, action));
            }
            ++i;
        }
    }

    public static class Select
    extends AbstractEntityListViewTableAction {
        public String getName() {
            return "\u9078\u629e";
        }

        public KeyStroke getAccelerator() {
            return KeyStroke.getKeyStroke(10, 0);
        }

        public void actionPerformed(ActionEvent e) {
            EntityListViewTable listViewTable = this.getListViewComponent(e);
            if (listViewTable.getInvoker() != null) {
                listViewTable.notifySelectionToInvoker();
                listViewTable.closeWinfow();
            } else {
                listViewTable.showDetail();
            }
        }

        public boolean isEnabled(EntityListViewTable table) {
            return table.getTable().getSelectedRow() > -1;
        }
    }

    public static class ShowDetail
    extends AbstractEntityListViewTableAction {
        public String getName() {
            return "\u8a73\u7d30\u8868\u793a";
        }

        public KeyStroke getAccelerator() {
            return null;
        }

        public void actionPerformed(ActionEvent e) {
            EntityListViewTable listViewTable = this.getListViewComponent(e);
            listViewTable.showDetail();
        }

        public boolean isEnabled(EntityListViewTable table) {
            return table.getTable().getSelectedRow() > -1;
        }
    }

    public static class Insert
    extends AbstractEntityListViewTableAction {
        public String getName() {
            return "\u65b0\u898f\u8ffd\u52a0";
        }

        public KeyStroke getAccelerator() {
            return KeyStroke.getKeyStroke(155, 0);
        }

        public void actionPerformed(ActionEvent e) {
            EntityListViewTable listViewTable = this.getListViewComponent(e);
            listViewTable.insertNewRow();
        }
    }

    public static class Delete
    extends AbstractEntityListViewTableAction {
        public String getName() {
            return "\u524a\u9664";
        }

        public KeyStroke getAccelerator() {
            return KeyStroke.getKeyStroke(127, 0);
        }

        public void actionPerformed(ActionEvent e) {
            EntityListViewTable listViewTable = this.getListViewComponent(e);
            listViewTable.deleteSelections();
        }

        public boolean isEnabled(EntityListViewTable table) {
            return table.getTable().getSelectedRow() > -1;
        }
    }

    public static class Refresh
    extends AbstractEntityListViewTableAction {
        public String getName() {
            return "\u6700\u65b0\u306e\u60c5\u5831\u306b\u66f4\u65b0";
        }

        public KeyStroke getAccelerator() {
            return KeyStroke.getKeyStroke(116, 0);
        }

        public void actionPerformed(ActionEvent e) {
            EntityListViewTable listViewTable = this.getListViewComponent(e);
            listViewTable.refresh();
        }

        public boolean isEnabled(EntityListViewTable table) {
            return table.getService() != null;
        }
    }
}

