/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gui.swing;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import org.asyrinx.brownie.core.lang.ClassUtils;
import org.asyrinx.brownie.swing.table.ListViewTable;
import org.asyrinx.joey.gui.EntityGuiRuntimeException;
import org.asyrinx.joey.gui.EntityListView;
import org.asyrinx.joey.gui.EntityPointer;
import org.asyrinx.joey.gui.EntityViewManager;
import org.asyrinx.joey.gui.swing.listview.DefaultEntityListViewTableActionKit;
import org.asyrinx.joey.gui.swing.listview.EntityListViewTableActionKit;
import org.asyrinx.joey.om.Entity;
import org.asyrinx.joey.om.EntityInitializer;
import org.asyrinx.joey.om.EntityService;
import org.asyrinx.joey.om.SearchCondition;

public abstract class EntityListViewTable
extends ListViewTable
implements EntityListView {
    private MouseListener mouseListener = null;
    private KeyListener keyListener = null;
    private EntityViewManager entityViewManager = null;
    private Object invoker = null;
    private static final int COL_INDEX_INVISIBLE_PRIMARY_KEY = 0;
    private JPopupMenu popupMenu = null;
    private EntityListViewTableActionKit actionKit;
    private EntityInitializer entityInitializer = EntityInitializer.NULL;
    private SearchCondition condition = null;
    private EntityService service = null;
    static /* synthetic */ Class class$0;

    public EntityListViewTable() {
    }

    public EntityListViewTable(int arg0, int arg1) {
        super(arg0, arg1);
    }

    public EntityListViewTable(Component arg0) {
        super(arg0);
    }

    public EntityListViewTable(Component arg0, int arg1, int arg2) {
        super(arg0, arg1, arg2);
    }

    protected void initialize() {
        super.initialize();
        this.addMouseListener(this.getMouseListener());
        this.addKeyListener(this.getKeyListener());
    }

    protected void initTable(JTable table) {
        super.initTable(table);
        table.addMouseListener(this.getMouseListener());
        table.addKeyListener(this.getKeyListener());
    }

    public KeyListener getKeyListener() {
        if (this.keyListener == null) {
            this.keyListener = new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 10: {
                            EntityListViewTable.this.notifySelectionToInvoker();
                        }
                    }
                }
            };
        }
        return this.keyListener;
    }

    public MouseListener getMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    switch (e.getButton()) {
                        case 1: {
                            switch (e.getClickCount()) {
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    if (EntityListViewTable.this.getInvoker() instanceof EntityPointer) {
                                        EntityListViewTable.this.notifySelectionToInvoker();
                                        EntityListViewTable.this.closeWinfow();
                                        break;
                                    }
                                    EntityListViewTable.this.showDetail();
                                }
                            }
                            break;
                        }
                        case 3: {
                            int row = EntityListViewTable.this.getTable().rowAtPoint(e.getPoint());
                            ListSelectionModel selectionModel = EntityListViewTable.this.getTable().getSelectionModel();
                            selectionModel.setLeadSelectionIndex(row);
                            selectionModel.setAnchorSelectionIndex(row);
                            EntityListViewTable.this.showPopupMenu(e);
                        }
                    }
                }
            };
        }
        return this.mouseListener;
    }

    public EntityViewManager getEntityViewManager() {
        return this.entityViewManager;
    }

    public void setEntityViewManager(EntityViewManager entityViewManager) {
        this.entityViewManager = entityViewManager;
    }

    public Object getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Object object) {
        this.invoker = object;
    }

    protected int getInvisibleColumnIndex() {
        return 0;
    }

    protected int getInvisibleColumnCount() {
        return 1;
    }

    public Serializable getKey(int tableRow) {
        int origianlRow = this.getSortableModel().getOriginalRowIndex(tableRow);
        Object object = this.getModel().getValueAt(origianlRow, 0);
        return (Serializable)object;
    }

    public Serializable getPointedKey() {
        int tableRow = this.getTable().getSelectedRow();
        return this.getKey(tableRow);
    }

    public void setPointedEntity(Entity entity) {
        if (entity == null) {
            this.setPointedKey(null);
        } else {
            this.setPointedKey(entity.getPrimaryKey());
        }
    }

    public void setPointedKey(Serializable key) {
        if (key == null) {
            return;
        }
        int row = 0;
        while (row < this.getTable().getRowCount()) {
            Serializable rowKey = this.getKey(row);
            if (key.equals(rowKey)) {
                this.getTable().getSelectionModel().setLeadSelectionIndex(row);
            }
            ++row;
        }
    }

    public abstract Class getEntityClass();

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.getActionKit().preparePopupMenu(this, this.popupMenu);
        }
        return this.popupMenu;
    }

    public EntityListViewTableActionKit getActionKit() {
        if (this.actionKit == null) {
            this.actionKit = new DefaultEntityListViewTableActionKit();
        }
        return this.actionKit;
    }

    public void setActionKit(EntityListViewTableActionKit kit) {
        this.actionKit = kit == null ? EntityListViewTableActionKit.NULL : kit;
    }

    protected void showPopupMenu(MouseEvent e) {
        this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
    }

    public void notifySelectionToInvoker() {
        Serializable key = this.getPointedKey();
        if (key == null) {
            return;
        }
        if (this.getInvoker() instanceof EntityPointer) {
            EntityPointer pointer = (EntityPointer)this.getInvoker();
            pointer.setPointedKey(this.getPointedKey());
        }
    }

    public void closeWinfow() {
        Window window = SwingUtilities.getWindowAncestor((Component)((Object)this));
        window.setVisible(false);
    }

    public void showDetail() {
        Serializable key = this.getPointedKey();
        if (key == null) {
            return;
        }
        this.getEntityViewManager().showDetailEditView(this, this.getEntityClass(), this.getPointedKey());
    }

    public EntityInitializer getEntityInitializer() {
        return this.entityInitializer;
    }

    public void setEntityInitializer(EntityInitializer initializer) {
        this.entityInitializer = initializer;
    }

    public void insertNewRow() {
        Entity entity;
        try {
            Class clazz = this.getEntityClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.asyrinx.joey.om.Entity");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            entity = (Entity)ClassUtils.newObject((Class)clazz, (Class)clazz2);
        }
        catch (InstantiationException e) {
            throw new EntityGuiRuntimeException(e);
        }
        this.getEntityInitializer().initialize(entity);
        this.getEntityViewManager().showDetailEditView(this, entity);
        this.refresh();
    }

    public void load(List entities) {
        this.clearList();
        Iterator iter = entities.iterator();
        while (iter.hasNext()) {
            Entity obj = (Entity)iter.next();
            this.loadEntity(obj);
        }
    }

    public abstract void loadEntity(Entity var1);

    public void deleteSelections() {
        if (this.getPointedKey() == null) {
            return;
        }
        int deleteConfirm = JOptionPane.showConfirmDialog((Component)((Object)this), "\u9078\u629e\u3057\u305f\u884c\u3092\u524a\u9664\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f", "\u524a\u9664\u78ba\u8a8d", 2);
        if (deleteConfirm != 0) {
            return;
        }
        try {
            this.getEntityViewManager().getEntityServiceManager().deleteEntity(this.getEntityClass(), this.getPointedKey());
            JOptionPane.showMessageDialog((Component)((Object)this), "\u524a\u9664\u3057\u307e\u3057\u305f");
            this.refresh();
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog((Component)((Object)this), "\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f", "\u30a8\u30e9\u30fc", 64);
        }
    }

    public void clearList() {
        this.getModel().setRowCount(0);
    }

    public SearchCondition getCondition() {
        return this.condition;
    }

    public void setCondition(SearchCondition condition) {
        this.condition = condition;
    }

    public EntityService getService() {
        if (this.service == null) {
            this.service = this.getEntityViewManager().getEntityServiceManager().getEntityService(this.getEntityClass());
        }
        return this.service;
    }

    public void setService(EntityService service) {
        this.service = service;
    }

    public void refresh() {
        EntityService entityService = this.getService();
        if (entityService != null) {
            this.clearList();
            List list = entityService.select(this.getCondition());
            this.load(list);
        }
    }

    public void beforeShow() {
    }

    public void afterShow() {
    }

    public void beforeHide() {
    }

    public void afterHide() {
    }
}

