/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.Serializable;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.asyrinx.brownie.core.util.Captionable;
import org.asyrinx.joey.gui.EntityGuiRuntimeException;
import org.asyrinx.joey.gui.EntityPointer;
import org.asyrinx.joey.gui.EntityViewManager;
import org.asyrinx.joey.gui.EntityViewManagerUser;
import org.asyrinx.joey.om.Entity;
import org.asyrinx.joey.om.SearchCondition;

public class EntityField
extends JPanel
implements EntityPointer,
EntityViewManagerUser {
    private JTextField captionField = null;
    private JButton selectButton = null;
    private JButton cancelButton = null;
    private JButton detailButton = null;
    private EntityViewManager entityViewManager = null;
    private boolean editable = true;
    private Serializable entityKey = null;
    private Class entityClass = null;
    static /* synthetic */ Class class$0;

    public EntityField() {
        this.initialize();
    }

    public EntityField(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.initialize();
    }

    public EntityField(LayoutManager layout) {
        super(layout);
        this.initialize();
    }

    public EntityField(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 0));
        this.add((Component)this.getCaptionField(), null);
        this.add((Component)this.getSelectButton(), null);
        this.add((Component)this.getCancelButton(), null);
        this.add((Component)this.getDetailButton(), null);
        this.setSize(314, 28);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                EntityField.this.updateButtonEnabled();
            }
        });
        this.updateButtonEnabled();
    }

    protected void updateButtonEnabled() {
        this.getSelectButton().setEnabled(this.isEditable() && this.getEntityClass() != null);
        this.getCancelButton().setEnabled(this.entityKey != null);
        this.getDetailButton().setEnabled(this.entityKey != null);
    }

    public JTextField getCaptionField() {
        if (this.captionField == null) {
            this.captionField = new JTextField();
            this.captionField.setEditable(false);
            this.captionField.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    EntityField.this.updateButtonEnabled();
                }
            });
        }
        return this.captionField;
    }

    public JButton getSelectButton() {
        if (this.selectButton == null) {
            this.selectButton = new JButton();
            this.selectButton.setPreferredSize(new Dimension(20, 20));
            this.selectButton.setText("");
            this.selectButton.setIcon(new ImageIcon(this.getClass().getResource("/org/asyrinx/joey/gui/swing/btn_list_enabled.png")));
            this.selectButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/org/asyrinx/joey/gui/swing/btn_list_disabled.png")));
            this.selectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EntityField.this.showSelection();
                }
            });
        }
        return this.selectButton;
    }

    public JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setPreferredSize(new Dimension(20, 20));
            this.cancelButton.setText("");
            this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/org/asyrinx/joey/gui/swing/btn_cancel_enabled.png")));
            this.cancelButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/org/asyrinx/joey/gui/swing/btn_cancel_disabled.png")));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EntityField.this.cancelSelection();
                }
            });
        }
        return this.cancelButton;
    }

    public JButton getDetailButton() {
        if (this.detailButton == null) {
            this.detailButton = new JButton();
            this.detailButton.setText("");
            this.detailButton.setPreferredSize(new Dimension(20, 25));
            this.detailButton.setActionCommand("");
            this.detailButton.setIcon(new ImageIcon(this.getClass().getResource("/org/asyrinx/joey/gui/swing/btn_detail_enabled.png")));
            this.detailButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/org/asyrinx/joey/gui/swing/btn_detail_disabled.png")));
            this.detailButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EntityField.this.showDetail();
                }
            });
        }
        return this.detailButton;
    }

    protected void showSelection() {
        this.entityViewManager.showSelectionListView((Object)this, this.getEntityClass(), (SearchCondition)null, this.getEntityKey());
    }

    protected void cancelSelection() {
        this.showEntity(null);
    }

    protected void showDetail() {
        this.entityViewManager.showDetailEditView(this, this.getEntityClass(), this.getEntityKey());
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean b) {
        this.editable = b;
        this.updateButtonEnabled();
    }

    public Serializable getEntityKey() {
        return this.entityKey;
    }

    public void setEntityKey(Serializable entityKey) {
        this.entityKey = entityKey;
        this.updateButtonEnabled();
    }

    public Serializable getPointedKey() {
        return this.getEntityKey();
    }

    public void setPointedEntity(Entity entity) {
        this.showEntity(entity);
    }

    public void setPointedKey(Serializable key) {
        if (this.getEntityViewManager() != null && this.getEntityViewManager().getEntityServiceManager() != null) {
            Entity entity = this.getEntityViewManager().getEntityServiceManager().loadEntity(this.getEntityClass(), key);
            this.showEntity(entity);
            return;
        }
        this.setEntityKey(key);
    }

    public void showEntity(Entity entity) {
        if (entity != null) {
            this.setEntityKey(entity.getPrimaryKey());
            if (entity instanceof Captionable) {
                this.getCaptionField().setText(((Captionable)entity).getCaption());
            } else {
                this.getCaptionField().setText(String.valueOf(entity.getPrimaryKey()));
            }
        } else {
            this.setEntityKey(null);
            this.getCaptionField().setText("");
        }
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class entityClass) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.asyrinx.joey.om.Entity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(entityClass)) {
            throw new EntityGuiRuntimeException("entityClass must be a sub-class of Entity");
        }
        this.entityClass = entityClass;
        this.updateButtonEnabled();
    }

    public EntityViewManager getEntityViewManager() {
        return this.entityViewManager;
    }

    public void setEntityViewManager(EntityViewManager viewManager) {
        this.entityViewManager = viewManager;
    }
}

