/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gui.impl;

import java.awt.Component;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.asyrinx.brownie.core.lang.ClassUtils;
import org.asyrinx.brownie.swing.SwingUtils;
import org.asyrinx.joey.gui.EntityEditView;
import org.asyrinx.joey.gui.EntityGuiRuntimeException;
import org.asyrinx.joey.gui.EntityListView;
import org.asyrinx.joey.gui.EntityView;
import org.asyrinx.joey.gui.EntityViewManager;
import org.asyrinx.joey.gui.EntityViewManagerUser;
import org.asyrinx.joey.om.Entity;
import org.asyrinx.joey.om.EntityService;
import org.asyrinx.joey.om.EntityServiceManager;
import org.asyrinx.joey.om.SearchCondition;
import org.seasar.framework.container.S2Container;

public abstract class AbstractEntityViewManager
implements EntityViewManager {
    protected final Map editViewMap = this.initEditViewMap();
    protected final Map listViewMap = this.initListViewMap();
    private S2Container container = null;
    private EntityServiceManager entityServiceManager = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected abstract Map initListViewMap();

    protected abstract Map initEditViewMap();

    protected EntityListView newListView(Class entityClass, Object invoker) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.asyrinx.joey.gui.EntityListView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (EntityListView)this.newEntityView(entityClass, this.listViewMap, clazz, invoker);
    }

    protected EntityEditView newEditView(Class entityClass, Object invoker) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.asyrinx.joey.gui.EntityEditView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (EntityEditView)this.newEntityView(entityClass, this.editViewMap, clazz, invoker);
    }

    protected EntityView newEntityView(Class entityClass, Map classMap, Class baseViewClass, Object invoker) {
        Class class1 = this.getClassFromMap(entityClass, classMap, baseViewClass);
        try {
            EntityView viewObj = (EntityView)ClassUtils.newObject((Class)class1, (Class)baseViewClass);
            if (invoker instanceof EntityViewManagerUser) {
                EntityViewManagerUser user = (EntityViewManagerUser)invoker;
                viewObj.setEntityViewManager(user.getEntityViewManager());
            } else {
                viewObj.setEntityViewManager(this);
            }
            return viewObj;
        }
        catch (InstantiationException e) {
            throw new EntityGuiRuntimeException(e);
        }
    }

    private Class getClassFromMap(Class entityClass, Map viewMap, Class baseClass) {
        Object object = viewMap.get(entityClass);
        if (!(object instanceof Class)) {
            throw new EntityGuiRuntimeException("Illegal class");
        }
        Class class1 = (Class)object;
        if (!baseClass.isAssignableFrom(class1)) {
            throw new EntityGuiRuntimeException("Illegal class - " + class1.getName() + " must extends " + baseClass);
        }
        return class1;
    }

    public EntityEditView getDetailEditView(Object invoker, Class entityClass) {
        return this.newEditView(entityClass, invoker);
    }

    public EntityListView getSelectionListView(Object invoker, Class entityClass) {
        return this.newListView(entityClass, invoker);
    }

    public EntityEditView showDetailEditView(Object invoker, Class entityClass, Serializable entityKey) {
        EntityService finder = this.getEntityServiceManager().getEntityService(entityClass);
        return this.showDetailEditView(invoker, entityClass, entityKey, finder);
    }

    public EntityEditView showDetailEditView(Object invoker, Class entityClass, Serializable entityKey, EntityService finder) {
        EntityEditView editView = this.getDetailEditView(invoker, entityClass);
        editView.setService(finder);
        editView.load(entityKey);
        this.showView(editView, invoker);
        return editView;
    }

    public EntityEditView showDetailEditView(Object invoker, Object entity) {
        EntityEditView editView = this.getDetailEditView(invoker, entity.getClass());
        editView.setService(null);
        if (entity instanceof Entity) {
            editView.setEntity((Entity)entity);
        }
        editView.loadFrom(entity);
        this.showView(editView, invoker);
        return editView;
    }

    public EntityListView showSelectionListView(Object invoker, Class entityClass, SearchCondition condition, Serializable selectedEntityKey) {
        EntityService finder = this.getEntityServiceManager().getEntityService(entityClass);
        return this.showSelectionListView(invoker, entityClass, condition, selectedEntityKey, finder);
    }

    public EntityListView showSelectionListView(Object invoker, Class entityClass, SearchCondition condition, Serializable selectedEntityKey, EntityService finder) {
        EntityListView listView = this.getSelectionListView(invoker, entityClass);
        listView.setCondition(condition);
        listView.setService(finder);
        listView.refresh();
        listView.setPointedKey(selectedEntityKey);
        this.showView(listView, invoker);
        return listView;
    }

    public EntityListView showSelectionListView(Object invoker, Class entityClass, List entities, Serializable selectedEntityKey) {
        EntityListView listView = this.getSelectionListView(invoker, entityClass);
        listView.setCondition(null);
        listView.setService(null);
        listView.load(entities);
        listView.setPointedKey(selectedEntityKey);
        this.showView(listView, invoker);
        return listView;
    }

    protected void showView(EntityView view, Object invoker) {
        view.setInvoker(invoker);
        if (!(view instanceof Component) || !(invoker instanceof Component)) {
            throw new EntityGuiRuntimeException(String.valueOf(view.getClass().getName()) + " can't be shown because it doesn't extends java.awt.Component.");
        }
        SwingUtils.showComponent((Component)((Component)((Object)view)), (Component)((Component)invoker), (int)800, (int)600, (String)"", (boolean)true);
    }

    public S2Container getContainer() {
        return this.container;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public EntityServiceManager getEntityServiceManager() {
        return this.entityServiceManager;
    }

    public void setEntityServiceManager(EntityServiceManager entityServiceManager) {
        this.entityServiceManager = entityServiceManager;
    }
}

