/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cfg;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cache.CacheProvider;
import net.sf.hibernate.cache.QueryCacheFactory;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.cfg.Settings;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.connection.ConnectionProviderFactory;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.GenericDialect;
import net.sf.hibernate.transaction.TransactionFactory;
import net.sf.hibernate.transaction.TransactionFactoryFactory;
import net.sf.hibernate.transaction.TransactionManagerLookup;
import net.sf.hibernate.transaction.TransactionManagerLookupFactory;
import net.sf.hibernate.util.PropertiesHelper;
import net.sf.hibernate.util.ReflectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SettingsFactory {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$cfg$SettingsFactory == null ? (class$net$sf$hibernate$cfg$SettingsFactory = SettingsFactory.class$("net.sf.hibernate.cfg.SettingsFactory")) : class$net$sf$hibernate$cfg$SettingsFactory));
    static /* synthetic */ Class class$net$sf$hibernate$cfg$SettingsFactory;
    static /* synthetic */ Class class$java$sql$DatabaseMetaData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Settings buildSettings(Properties properties) throws HibernateException {
        boolean showSql;
        Integer maxFetchDepth;
        Dialect dialect;
        Settings settings = new Settings();
        try {
            dialect = Dialect.getDialect(properties);
            Properties temp = new Properties();
            temp.putAll((Map<?, ?>)dialect.getDefaultProperties());
            temp.putAll((Map<?, ?>)properties);
            properties = temp;
        }
        catch (HibernateException he) {
            log.warn((Object)("No dialect set - using GenericDialect: " + he.getMessage()));
            dialect = new GenericDialect();
        }
        Integer statementFetchSize = PropertiesHelper.getInteger("hibernate.jdbc.fetch_size", properties);
        if (statementFetchSize != null) {
            log.info((Object)("JDBC result set fetch size: " + statementFetchSize));
        }
        if ((maxFetchDepth = PropertiesHelper.getInteger("hibernate.max_fetch_depth", properties)) != null) {
            log.info((Object)("Maximim outer join fetch depth: " + maxFetchDepth));
        }
        boolean useOuterJoin = PropertiesHelper.getBoolean("hibernate.use_outer_join", properties, true);
        log.info((Object)("Use outer join fetching: " + useOuterJoin));
        ConnectionProvider connections = ConnectionProviderFactory.newConnectionProvider(properties);
        TransactionFactory transactionFactory = TransactionFactoryFactory.buildTransactionFactory(properties);
        TransactionManagerLookup transactionManagerLookup = TransactionManagerLookupFactory.getTransactionManagerLookup(properties);
        boolean metaSupportsScrollable = false;
        boolean metaSupportsGetGeneratedKeys = false;
        int batchSize = PropertiesHelper.getInt("hibernate.jdbc.batch_size", properties, 0);
        try {
            Connection conn = connections.getConnection();
            try {
                DatabaseMetaData meta = conn.getMetaData();
                metaSupportsScrollable = meta.supportsResultSetType(1004);
                if (batchSize > 0 && !meta.supportsBatchUpdates()) {
                    batchSize = 0;
                }
                if (Environment.jvmSupportsGetGeneratedKeys()) {
                    try {
                        Boolean result = (Boolean)(class$java$sql$DatabaseMetaData == null ? (class$java$sql$DatabaseMetaData = SettingsFactory.class$("java.sql.DatabaseMetaData")) : class$java$sql$DatabaseMetaData).getMethod("supportsGetGeneratedKeys", null).invoke((Object)meta, null);
                        metaSupportsGetGeneratedKeys = result;
                    }
                    catch (AbstractMethodError ame) {
                        metaSupportsGetGeneratedKeys = false;
                    }
                    catch (Exception e) {
                        metaSupportsGetGeneratedKeys = false;
                    }
                }
            }
            finally {
                connections.closeConnection(conn);
            }
        }
        catch (SQLException sqle) {
            log.warn((Object)"Could not obtain connection metadata", (Throwable)sqle);
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        boolean useScrollableResultSets = PropertiesHelper.getBoolean("hibernate.jdbc.use_scrollable_resultset", properties, metaSupportsScrollable);
        log.info((Object)("Use scrollable result sets: " + useScrollableResultSets));
        boolean useGetGeneratedKeys = PropertiesHelper.getBoolean("hibernate.jdbc.use_get_generated_keys", properties, metaSupportsGetGeneratedKeys);
        log.info((Object)("Use JDBC3 getGeneratedKeys(): " + useGetGeneratedKeys));
        boolean useMinimalPuts = PropertiesHelper.getBoolean("hibernate.cache.use_minimal_puts", properties, false);
        log.info((Object)("Optimize cache for minimal puts: " + useMinimalPuts));
        String defaultSchema = properties.getProperty("hibernate.default_schema");
        if (defaultSchema != null) {
            log.info((Object)("Default schema set to: " + defaultSchema));
        }
        if (showSql = PropertiesHelper.getBoolean("hibernate.show_sql", properties)) {
            log.info((Object)"echoing all SQL to stdout");
        }
        Map querySubstitutions = PropertiesHelper.toMap("hibernate.query.substitutions", " ,=;:\n\t\r\f", properties);
        log.info((Object)("Query language substitutions: " + querySubstitutions));
        String autoSchemaExport = properties.getProperty("hibernate.hbm2ddl.auto");
        if ("update".equals(autoSchemaExport)) {
            settings.setAutoUpdateSchema(true);
        }
        if ("create".equals(autoSchemaExport)) {
            settings.setAutoCreateSchema(true);
        }
        if ("create-drop".equals(autoSchemaExport)) {
            settings.setAutoCreateSchema(true);
            settings.setAutoDropSchema(true);
        }
        String cacheClassName = PropertiesHelper.getString("hibernate.cache.provider_class", properties, "net.sf.hibernate.cache.EhCacheProvider");
        log.info((Object)("cache provider: " + cacheClassName));
        try {
            settings.setCacheProvider((CacheProvider)ReflectHelper.classForName(cacheClassName).newInstance());
        }
        catch (Exception cnfe) {
            throw new HibernateException("could not instantiate CacheProvider: " + cacheClassName, cnfe);
        }
        boolean useQueryCache = PropertiesHelper.getBoolean("hibernate.cache.use_query_cache", properties);
        if (useQueryCache) {
            String queryCacheFactoryClassName = PropertiesHelper.getString("hibernate.cache.query_cache_factory", properties, "net.sf.hibernate.cache.StandardQueryCacheFactory");
            log.info((Object)("query cache factory: " + queryCacheFactoryClassName));
            try {
                settings.setQueryCacheFactory((QueryCacheFactory)ReflectHelper.classForName(queryCacheFactoryClassName).newInstance());
            }
            catch (Exception cnfe) {
                throw new HibernateException("could not instantiate QueryCacheFactory: " + queryCacheFactoryClassName, cnfe);
            }
        }
        String sessionFactoryName = properties.getProperty("hibernate.session_factory_name");
        boolean jdbcBatchVersionedData = PropertiesHelper.getBoolean("hibernate.jdbc.batch_versioned_data", properties, false);
        settings.setStatementFetchSize(statementFetchSize);
        settings.setScrollableResultSetsEnabled(useScrollableResultSets);
        settings.setGetGeneratedKeysEnabled(useGetGeneratedKeys);
        settings.setJdbcBatchSize(batchSize);
        settings.setDefaultSchemaName(defaultSchema);
        settings.setShowSqlEnabled(showSql);
        settings.setDialect(dialect);
        settings.setConnectionProvider(connections);
        settings.setQuerySubstitutions(querySubstitutions);
        settings.setTransactionFactory(transactionFactory);
        settings.setTransactionManagerLookup(transactionManagerLookup);
        settings.setSessionFactoryName(sessionFactoryName);
        settings.setOuterJoinFetchEnabled(useOuterJoin);
        settings.setMaximumFetchDepth(maxFetchDepth);
        settings.setQueryCacheEnabled(useQueryCache);
        settings.setMinimalPutsEnabled(useMinimalPuts);
        settings.setJdbcBatchVersionedData(jdbcBatchVersionedData);
        return settings;
    }

    private SettingsFactory() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

