/* -----------------------------------------------------------------------
 JavaSyntaxScanner.java
 Copyright (C) 2004  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2004/01/17
 *
 * File Name: JavaSyntaxScanner.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 *
 */
package jp.co.jlight.stylers;

import java.util.*;
import java.io.*;
/**
 * JavaѤιʸϴ
 */
public class JavaSyntaxScanner extends SyntaxScanner {

	protected Hashtable fgKeys= null;
	protected StringBuffer fBuffer= new StringBuffer();
	protected boolean fEofSeen= false;

	Vector blockComments = new Vector();

	/**
	 * ɤ
	 */
	private String[] fgKeywords= { 
		"abstract",
		"boolean", "break", "byte",
		"case", "catch", "char", "class", "continue",
		"default", "do", "double",
		"else", "extends",
		"false", "final", "finally", "float", "for",
		"if", "implements", "import", "instanceof", "int", "interface",
		"long",
		"native", "new", "null",
		"package", "private", "protected", "public",
		"return",
		"short", "static", "super", "switch", "synchronized",
		"this", "throw", "throws", "transient", "true", "try",
		"void", "volatile",
		"while"
	};

	/**
	 * 󥹥ȥ饯ǥʤ
	 */
	public JavaSyntaxScanner() {
		initialize();
	}

	void initialize() {
		fgKeys = new Hashtable();
		// ʸϥɤǤ
		Integer k = new Integer(StylerKeys.KEY);
		for (int i = 0; i < fgKeywords.length; i++)
			fgKeys.put(fgKeywords[i], k);
	}

	public int nextToken() {
		int c;
		fStartToken= fPos;
		while (true) {
			switch (c= read()) {			
			case StylerKeys.EOF:
				return StylerKeys.EOF;				
			case '/':	// comment
				c= read();
				if (c == '/') {
					while (true) {
						c= read();
						if ((c == StylerKeys.EOF) || (c == StylerKeys.EOL)) {
							unread(c);
							return StylerKeys.COMMENT;
						}
					}
				} else {
					unread(c);
				}
				return StylerKeys.OTHER;
			case '\'':	// char const
				character: for(;;) {
					c= read();
					switch (c) {
						case '\'':
							return StylerKeys.STRING;
						case StylerKeys.EOF:
							unread(c);
							return StylerKeys.STRING;
						case '\\':
							c= read();
							break;
						}
				}

			case '"':	// string
				string: for (;;) {
					c= read();
					switch (c) {
						case '"':
							return StylerKeys.STRING;
						case StylerKeys.EOF:
							unread(c);
							return StylerKeys.STRING;
						case '\\':
							c= read();
							break;
						}
				}

			case '0': case '1': case '2': case '3': case '4':
			case '5': case '6': case '7': case '8': case '9':
				do {
					c= read();
				} while(Character.isDigit((char)c));
				unread(c);
				return StylerKeys.NUMBER;
			default:
				if (Character.isWhitespace((char)c)) {
					do {
						c= read();
					} while(Character.isWhitespace((char)c));
					unread(c);
					return StylerKeys.WHITE;
				}
				if (Character.isJavaIdentifierStart((char)c)) {
					fBuffer.setLength(0);
					do {
						fBuffer.append((char)c);
						c= read();
					} while(Character.isJavaIdentifierPart((char)c));
					unread(c);
					Integer i= (Integer) fgKeys.get(fBuffer.toString());
					if (i != null)
						return i.intValue();
						return StylerKeys.WORD;
				}
				return StylerKeys.OTHER;
			}
		}
	}

	/**
	 * ֥åȤϤ
	 * @param text
	 */
	public Vector parseBlockComments(String text) {
		blockComments = new Vector();
		StringReader buffer = new StringReader(text);
		int ch;
		boolean blkComment = false;
		int cnt = 0;
		int[] offsets = new int[2];
		boolean done = false;
	
		try {
		while (!done) {
			switch (ch = buffer.read()) {
				case -1 : {
					if (blkComment) {
						offsets[1] = cnt;
						blockComments.addElement(offsets);
					}
					done = true;
					break;
				}
				case '/' : {
					ch = buffer.read();
					if ((ch == '*') && (!blkComment)) {
						offsets = new int[2];
						offsets[0] = cnt;
						blkComment = true;
						cnt++;	
					} else {
						cnt++;
					}						
					cnt++;
					break;
				}
				case '*' : {
					if (blkComment) {
						ch = buffer.read();
						cnt++;
						if (ch == '/') {
							blkComment = false;	
							offsets[1] = cnt;
							blockComments.addElement(offsets);
						}
					}
					cnt++;	
					break;
				}
				default : {
					cnt++;				
					break;
				}
			}
		}		
		} catch(IOException e) {
			// ignore errors
		}
		
		return blockComments;
	}

}
