/* -----------------------------------------------------------------------
 EncodeSet.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/03/06
 *
 * File Name: EncodeSet.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 * 
 */
package jp.co.jlight;

//import java.nio.charset.*;
import java.io.*;
import java.util.*;
/**
 * 󥳡ǥ󥰤˻Ȥ饯åȤݻ
 */
public class EncodeSet {

	private ArrayList encs;
	
	private static final String defaultEncoding = getDefaultEncode();

	private static final String SEPARATOR = System.getProperty("file.separator");
	private static ResourceBundle resources = ResourceBundle.getBundle("resources.jlighteditor");
	private File resFile;

	/**
	 * EncodeSet饹󥹥ȥ饯
	 */
	public EncodeSet() {
		String fileName = resources.getString("EncodeFileName");
		String userDir = System.getProperty("user.dir");
		resFile = new File(userDir + SEPARATOR + "resources" + SEPARATOR + fileName);
		encs = new ArrayList();
		createEncodeSet();

	}

	private static String getDefaultEncode() {
		String enc;
		OutputStreamWriter out = new OutputStreamWriter(new ByteArrayOutputStream());
		enc = out.getEncoding();

		return enc;
	}

	/**
	 * ե뤫饨󥳡ǥ󥰾ɤ߹ߺ
	 */
	private void createEncodeSet() {
		int id = 0;
		String realName = defaultEncoding;
		String dispName = realName + " (Default)";
		Encode encode = new Encode(id, dispName, realName);
		encs.add(encode);

//		Charset cs = null;
		
		// MS932к(㳰ȯj2sdk1.4.1)
//		Charset defcs = Charset.forName(defaultEncoding);
//		if (defaultEncoding.equals("MS932")) {
//			defaultEncoding = "SJIS";
//		}
//		Charset defcs = Charset.forName(defaultEncoding);


		OutputStreamWriter osw;
		OutputStream out = new ByteArrayOutputStream();

		FileReader fr = null;
		BufferedReader br = null;
		String line = "";
		try {
			fr = new FileReader(resFile.getPath());
			br = new BufferedReader(fr);
			int idx = 0;

			while ((line = br.readLine()) != null) {
				idx = line.indexOf('=');
				realName = line.substring(0, idx);

				try {
					osw = new OutputStreamWriter(out, realName);
					if (!realName.equals(defaultEncoding)) {
						dispName = line.substring(idx + 1);
						encs.add(new Encode(++id, dispName, realName));
					}
				} catch (UnsupportedEncodingException e) {
					System.err.println("UnsupportedEncodingException :" + e.getMessage());
				}
			}

		} catch (FileNotFoundException e) {
			System.err.println("FileNotFoundException: " + 
								resFile.getAbsolutePath());
		} catch (IOException e) {
			System.err.println("IOException: readLine()");
		} finally {
			if (br != null) {
				try {
					br.close();
				} catch (IOException e) {
				}
			}
			if (fr != null) {
				try {
					fr.close();
				} catch (IOException e) {
				}
			}
		}
	}


	/**
	 * ץåȥեΥǥեCharset
	 * @return Charset
	 */
//	private Charset getDefaultCharset() {
//		return Charset.forName(defaultEncoding);
//	}

	/**
	 * ץåȥեΥǥեȥ󥳡ǥ󥰤
	 * @return String
	 */
	public String getDefaultEncoding() {
		return defaultEncoding.toUpperCase();
	}

	/**
	 * Ǥ륨󥳡ɤο
	 * @return int
	 */
	public int getCount() {
		return encs.size();
	}

	/**
	 * id˴Ϣդ줿󥳡̾
	 * @param id
	 * @return String
	 */
	public String getRealEncodeName(int id) {
		if (id < 0 | id > (getCount() - 1)) return "";
		Encode encode = (Encode)(encs.get(id));
		return encode.getRealEncoding();
	}

	/**
	 * id˴Ϣդ줿󥳡̾(˥塼ɽ)
	 * @param id
	 * @return String
	 */
	public String getDispEncodeName(int id) {
		if (id < 0 | id > (getCount() - 1)) return "";
		Encode encode = (Encode)(encs.get(id));
		return encode.getDispEncoding();
	}



	class Encode {
		private int id;
		private String dispEncoding;
		private String realEncoding;

		/**
		 * Encode饹󥹥ȥ饯
		 * @param id
		 * @param displayName
		 * @param realName
		 */
		public Encode(int id, String displayName, String realName) {
			this.id = id;
			this.dispEncoding = displayName;
			this.realEncoding = realName;
		}

		/**
		 * @return int
		 */
		public int getId() {
			return id;
		}
		/**
		 * @return String
		 */
		public String getDispEncoding() {
			return dispEncoding;
		}
		/**
		 * @return String
		 */
		public String getRealEncoding() {
			return realEncoding;
		}
	}

}
