/* -----------------------------------------------------------------------
 ControlSet.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/02/25
 *
 * File Name: ControlSet.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 * 
 */
package jp.co.jlight;

import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.dnd.*;

import jp.co.jlight.undo.*;
import jp.co.jlight.stylers.*;
/**
 * ץꥱǻѤ륪֥Ȥ
 *       ޤȤ᤿Ρ
 */
public class ControlSet implements DisposeListener {

//	private JavaLineStyler lineStyler = new JavaLineStyler();
	private LineStyler lineStyler;

	private String fileName = "";		// ե̾
	private String path = "";			// եѥ(ǼƤǥ쥯ȥ)
	private String fullFileName = "";	// եե͡

	private boolean flgNew;				// ե饰(true:false:¸)
	private boolean isEdited = false;	// Խɤ
//	private boolean isReadOnly;			// ꡼ɥ꡼ե뤫ɤ

	private ModifyListener modifyListener;
	private KeyListener keyListener;
	private MouseListener mouseListener;
	private ModifyListener lineModifyListener = null;

	private Color lineColor;
	private Color offColor;
	private int nowLine = 0;

	private int key;
	private int id;
	private StyledText text;	// StyledText
	private TabItem item;		// TabItem
	
	private static TabFolder tabfolder = null;	// 饹ѿ

	private static Label stat = null;
	private static Label linecolumn = null;

	private static MenuManager mm = null;
	private Undoable undoable = null;

	private String syntax = "";
	private static SyntaxSet ss = new SyntaxSet();

	/**
	 * ControlSet饹󥹥ȥ饯(ɬ)
	 * @param fileName		ե̾
	 * @param isNew			ɤ
	 * @param tabFolder		TabFolder֥
	 * @param key			key
	 * @param id			ID
	 */
	public ControlSet(String fileName, boolean isNew, TabFolder tabFolder, int key, int id) {
		if (tabfolder == null) tabfolder = tabFolder;
		this.fileName = fileName;
		this.flgNew = isNew;
		this.item = createTabItem(fileName, tabfolder);
		this.text = createStyledText(tabfolder);
		this.id = id;
		this.key = key;
		item.setControl(text);
		createUndoable();
		setTextListener();
		setDefaultSyntaxStyle();
//		lineStyler.parseBlockComments(text.getText());
	}

	/**
	 * ControlSet饹󥹥ȥ饯
	 * @param fileName		ե̾
	 * @param isNew			ɤ
	 * @param tabFolder		TabFolder֥
	 * @param key			key
	 * @param id			ID
	 * @param status		ơ٥
	 * @param lineColumn	ֹ٥
	 */
	public ControlSet(String fileName, boolean isNew, TabFolder tabFolder,
	                 int key, int id, Label status, Label lineColumn) {
		this(fileName, isNew, tabFolder, key, id);
		if (stat == null) stat = status;
		if (linecolumn == null) linecolumn = lineColumn;
	}

	/**
	 * ControlSet饹󥹥ȥ饯
	 * @param fileName		ե̾
	 * @param isNew			ɤ
	 * @param tabFolder		TabFolder֥
	 * @param key			key
	 * @param id			ID
	 * @param status		ơ٥
	 * @param lineColumn	ֹ٥
	 * @param menuManager	˥塼ޥ͡㡼
	 */
	public ControlSet(String fileName, boolean isNew, TabFolder tabFolder,
					 int key, int id, Label status, Label lineColumn, MenuManager menuManager) {
		this(fileName, isNew, tabFolder, key, id, status, lineColumn);
		if (mm == null) mm = menuManager;
	}

	/**
	 * StyledTextǼTabItem֥Ȥ
	 * @param fn		֤ɽե̾
	 * @param tabFolder	TabItemǼTabFolder
	 * @return TabItem	TabItem֥
	 */
	private TabItem createTabItem(String fn, TabFolder tabFolder) {
		TabItem tabItem = new TabItem(tabfolder, SWT.NULL);
		tabItem.setText(fn);

		tabItem.addDisposeListener(this);

		return tabItem;
	}

	/**
	 * StyledText֥Ȥ
	 * @param composite		StyledTextǼComposite
	 * @return StyledText	StyledText֥
	 */
	private StyledText createStyledText(Composite composite) {
		StyledText txt = new StyledText(composite, SWT.FULL_SELECTION |
			SWT.BORDER | SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);

		return txt;
	}

	/**
	 * UndoableListenerʡ饹饤󥹥󥹤
	 */
	private void createUndoable() {
		undoable = new DefaultUndoableTextListener(text, true);
		undoable.setTextListener();
		
		text.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent event) {
				setUndoRedoEnabled();
			}
		});
	}
	
	/**
	 * Undo¹Ԥ
	 */
	public void undo() {
		if (undoable != null) {
			undoable.undo();
			text.setFocus();
			setLineBackground();
			setLineColumn();
			setUndoRedoEnabled();
		}
	}
	
	/**
	 * Redo¹Ԥ
	 */
	public void redo() {
		if (undoable != null) {
			undoable.redo();
			text.setFocus();
			setLineBackground();
			setLineColumn();
			setUndoRedoEnabled();
		}
	}

	/**
	 * UndoRedo˥塼ѲǽԲǽꤹ
	 */
	private void setUndoRedoEnabled() {
		if (mm != null && undoable != null) {
			mm.getItemEditUndo().setEnabled(undoable());
			mm.getItemEditRedo().setEnabled(redoable());
		}
	}

	/**
	 * Undoǽɤ֤
	 * @return boolean
	 */
	public boolean undoable() {
		if (undoable == null) {
			return false;
		} 
		return undoable.undoable();
	}

	/**
	 * Redoǽɤ֤
	 * @return boolean
	 */
	public boolean redoable() {
		if (undoable == null) {
			return false;
		}
		return undoable.redoable();
	}

	/**
	 * StyledText˥ꥹʡ
	 */
	private void setTextListener() {
//		lineColor = new Color(text.getDisplay(), new RGB(225, 240, 185));
		lineColor = new Color(text.getDisplay(), new RGB(205, 215, 230));
		offColor = text.getBackground();

		// ꥹʡ饹μɲ
		modifyListener = new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				setEdited(true);
//				lineStyler.parseBlockComments(text.getText());
			}
		};
		text.addModifyListener(modifyListener);

		mouseListener = new MouseAdapter() {
			public void mouseDown(MouseEvent e) {
				setLineBackground();
				setLineColumn();
			}
		};
		text.addMouseListener(mouseListener);

		keyListener = new KeyAdapter() {
			public void keyPressed(KeyEvent e) {
				setLineBackground();
				setLineColumn();
			}
		};
		text.addKeyListener(keyListener);


//		text.addLineStyleListener(lineStyler);
	}


	private void setLineStyler() {
		text.addLineStyleListener(lineStyler);

		if (lineModifyListener == null) {
			lineModifyListener = new ModifyListener() {
				public void modifyText(ModifyEvent event) {
					lineStyler.parseBlockComments(text.getText());
				}
			};
		}
		text.addModifyListener(lineModifyListener);

		text.redraw();
		lineStyler.parseBlockComments(text.getText());
	}

	private void removeLineStyler() {
		if (lineStyler != null) {
			text.removeLineStyleListener(lineStyler);
		}
		if (lineModifyListener == null) return;
		text.removeModifyListener(lineModifyListener);

		text.redraw();
	}

	private void setDefaultSyntaxStyle() {
		setSyntax(ss.getDefaultSyntax());
	}

	/**
	 * ʸϴꤹ
	 * @param lang
	 */
	public void setSyntax(String lang) {
		// ʸ󤬽Ǥ뤫ɤ
		if (!ss.checkSyntax(lang)) {
			this.syntax = "NON";
			removeLineStyler();
		}
		this.syntax = lang;
		if (syntax.equals("NON")) {
			removeLineStyler();
		} else {
			if (lineStyler == null) {
				lineStyler = new LineStyler(lang);
			} else {
				lineStyler.setLineStyler(lang);
			}
			setLineStyler();
		}
	}

	/**
	 * ߤιʸʸ
	 * @return
	 */
	public String getSyntax() {
		return syntax;
	}

	/**
	 * ֥Ȥdispose줿ν
	 * (StyledTextγƼꥹʡ)
	 */
	public void widgetDisposed(DisposeEvent e) {
		if (text != null) {
			text.removeModifyListener(modifyListener);
			text.removeKeyListener(keyListener);
			text.removeMouseListener(mouseListener);
			if (lineStyler != null) {
				lineStyler.dispose();
				text.removeLineStyleListener(lineStyler);
			}
			if (lineModifyListener != null) {
				text.removeModifyListener(lineModifyListener);
			}
		}
	}

	/**
	 * ΤԤϥ饤ɽ
	 */
	private void setLineBackground() {
		int caret = text.getCaretOffset();
		int line = text.getLineAtOffset(caret);
		int count = text.getLineCount();

		if (nowLine >= count) {
			nowLine = count - 1;
		}
		// ߤΥ饤󥫥顼򥪥դˤƥ饤ɥ
		text.setLineBackground(nowLine, 1, offColor);
		int start = text.getOffsetAtLine(nowLine);
		int end = 0;
		int length = 0;
		if ((nowLine + 1) < count) {
			end = text.getOffsetAtLine((nowLine + 1));
			if (end >= start) {
				length = end - start;
			}
		}
		text.redrawRange(start, length, true);

		// 饤
		text.setLineBackground(line, 1, lineColor);
		nowLine = line;

		// 饤ɥ
		start = text.getOffsetAtLine(nowLine);
		end = 0;
		length = 0;
		if ((nowLine + 1) < count) {
			end = text.getOffsetAtLine((nowLine + 1));
			if (end >= start) {
				length = end - start;
			}
		}
		text.redrawRange(start, length, true);

	}

	/**
	 * ֹ桢ֹ٥˽񤭹
	 */
	private void setLineColumn() {
		if (linecolumn == null) return;
		
		int caret = text.getCaretOffset();
		int line = text.getLineAtOffset(caret);
		int columnAtLine = caret - text.getOffsetAtLine(line) + 1;

		linecolumn.setText("Line : " + (line + 1) + "/"
					   + text.getLineCount()
					   + "  Column : " + columnAtLine);
	}

	/**
	 * ֹ桢ֹ٥˽񤭹ѥ֥å᥽å
	 */
	public void setLineAndColumn() {
		setLineColumn();
	}


	/**
	 * DropTargetɥåץꥹʡ
	 * @param receiver
	 */
	public void setDropText(DndReceiver receiver) {
//		int operations = DND.DROP_MOVE | DND.DROP_COPY | DND.DROP_LINK;
		int operations = DND.DROP_DEFAULT | DND.DROP_LINK;
		Transfer[] types = new Transfer[] {FileTransfer.getInstance()};
		DropTarget target = new DropTarget(text, operations);
		target.setTransfer(types);

		target.addDropListener(new DndSet(receiver));
	}


	/**
	 * @return String
	 */
	public String getFileName() {
		return fileName;
	}

	/**
	 * flgNewѥ᡼
	 * @return boolean
	 */
	public boolean getFlgNew() {
		return flgNew;
	}

	/**
	 * ե̾
	 * @param fileName The fileName to set
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	/**
	 * flgNewѥ᡼
	 * @param flgNew The flgNew to set
	 */
	public void setFlgNew(boolean isNew) {
		this.flgNew = isNew;
	}

	/**
	 * TabItem֥Ȥ
	 * @return TabItem
	 */
	public TabItem getTabItem() {
		return item;
	}

	/**
	 * StyledText֥Ȥ
	 * @return StyledText
	 */
	public StyledText getStyledText() {
		return text;
	}

	/**
	 * TabItem˥ƥ(ե̾)
	 * @param name
	 */
	public void setTabItemText(String name) {
		item.setText(name);
	}

	/**
	 * եγǼƤǥ쥯ȥ
	 * @return String
	 */
	public String getPath() {
		return path;
	}

	/**
	 * եؤΥեѥ
	 * @return String
	 */
	public String getFullName() {
		return fullFileName;
	}

	/**
	 * եγǼƤǥ쥯ȥ
	 * @param path
	 */
	public void setPath(String path) {
		this.path = path;
	}

	/**
	 * եؤΥեѥ
	 * @param fullName
	 */
	public void setFullName(String fullName) {
		this.fullFileName = fullName;
	}

	/**
	 * ߤIDǥ
	 */
	public void decrementID() {
		id--;
	}

	/**
	 * ID
	 * @param id
	 */
	public void setID(int id) {
		this.id = id;
	}

	/**
	 * ID
	 * @return int
	 */
	public int getID() {
		return id;
	}

	/**
	 * ControlSetꤹ뤿Υ
	 * @return int
	 */
	public int getKey() {
		return key;
	}

	/**
	 * Խ줿ɤΥѥ᡼
	 * @return boolean
	 */
	public boolean getEdited() {
		return isEdited;
	}

	/**
	 * Խ줿ɤΥѥ᡼
	 * @param b
	 */
	public void setEdited(boolean b) {
		this.isEdited = b;
	}

	/**
	 * ƥΤ
	 */
	public void selectAll() {
		setFocus();
		text.selectAll();
	}
	
	/**
	 * ƥȤ˥եܤ
	 */
	public void setFocus() {
		text.setFocus();
	}
	
	/**
	 * StyledTextcaret֤
	 * @return int
	 */
	public int getCaretOffset() {
		return text.getCaretOffset();
	}
	
	/**
	 * StyledText򤵤줿ʸ
	 * @return String
	 */
	public String getSelectionText() {
		return text.getSelectionText();
	}
	
	/**
	 * StyledTextλꤵ줿֤ΥƥȤꤵ줿ʸִ
	 * @param start		Ȱ
	 * @param length	Ĺ
	 * @param txt		ʸ
	 */
	public void replaceTextRange(int start, int length, String txt) {
		try {
			Point delPoint = new Point(start, length);
			Point addPoint = new Point(start, txt.length());
			String delString = text.getTextRange(start, length);
			text.setCaretOffset(start);
			text.replaceTextRange(start, length, txt);
			undoable.add(delPoint, delString, addPoint, txt);
		} catch (IllegalArgumentException e) {
			System.err.println("IllegalArgumentException !!!" + e.getMessage());
		}
	}

	/**
	 *ִѤα޽
	 *  Ϣ³ϤǤʤƤĤΥޥ()Ȥ
	 * 
	 * @param replaceAll	ִ(true),ʳ(false)
	 */
	public void setOneSegment(boolean replaceAll) {
		undoable.setOneSegment(replaceAll);
	}

	public Point getSelectionRange() {
		return text.getSelectionRange();
	}

	/**
	 * StyledTextλꤵ줿ʸ֤ˤ
	 * @param start		Ȱ
	 * @param length	Ĺ
	 */
	public void setSelectionRange(int start, int length) {
		try {
			text.setSelectionRange(start, length);
			text.showSelection();
		} catch (IllegalArgumentException e) {
			System.err.println(e.getMessage());
		}
	}
}

