/* -----------------------------------------------------------------------
 DefaultUndoableTextListener.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/11/24
 *
 * File Name: DefaultUndoableTextListener.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 *
 */
package jp.co.jlight.undo;

import org.eclipse.swt.custom.*;
import org.eclipse.swt.events.*;
/**
 * 
 */
public class DefaultUndoableTextListener implements Undoable {

	private CommandStack history;
	private TextListener listener;
	
	private StyledText text;
	private boolean added = false;

	public DefaultUndoableTextListener(StyledText text) {
		this.text = text;
		history = new CommandStack();
		listener = new TextListener(history, text);
	}

	public DefaultUndoableTextListener(StyledText text, boolean record) {
		this(text);
		listener.setRecordHistory(record);
	}

	public void undo() {
		if (added && listener.getRecordHistory()) {
			listener.setRecordHistory(false);
			history.undo();
			listener.setRecordHistory(true);
		}
	}
	
	public void redo() {
		if (added && listener.getRecordHistory()) {
			listener.setRecordHistory(false);
			history.redo();
			listener.setRecordHistory(true);
		}
	}
	
	public void setRecordHistory(boolean record) {
		listener.setRecordHistory(record);
	}
	
	public boolean getRecordHistory() {
		return listener.getRecordHistory();
	}
	
	public void setTextListener() {
		setTextListener(listener, listener, listener);
	}
	
	protected void setTextListener(VerifyListener verifyListener,
					ModifyListener modifyListener, VerifyKeyListener verifyKeyListener) {
		if (text != null) {
			text.addVerifyListener(verifyListener);
			text.addModifyListener(modifyListener);
			text.addVerifyKeyListener(verifyKeyListener);
			added = true;
		}
	}
	
	protected TextListener getTextListener() {
		return listener;
	}
	
	public void verifyText(VerifyEvent event) {
		listener.verifyText(event);
	}
	
	public void modifyText(ModifyEvent event) {
		listener.modifyText(event);
	}
	
	public void verifyKey(VerifyEvent event) {
		listener.verifyKey(event);
	}
}
