/* -----------------------------------------------------------------------
 MenuManager.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/02/25
 *
 * File Name: MenuManager.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 * 
 */
package jp.co.jlight;

import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.*;
import java.util.*;
/**
 * ˥塼С륯饹
 */
public class MenuManager implements SelectionListener, Sender {

	private Shell shell = null;

	private Receiver receiver;

	private Menu bar;
	private MenuItem itemFileNew;
	private MenuItem itemFileOpen;
	private MenuItem itemFileClose;
	private MenuItem itemFileSave;
	private MenuItem itemFileSaveAs;
	private MenuItem itemFileExit;

	private MenuItem itemEditUndo;
	private MenuItem itemEditRedo;
	private MenuItem itemEditCut;
	private MenuItem itemEditCopy;
	private MenuItem itemEditPaste;

	private MenuItem itemSettingFont;
	private Menu menuEncode;

	private MenuItem itemHelpAbout;

	private Hashtable actions;
	private EncodeSet es = new EncodeSet();

	private static Resources resources = new Resources();


	/**
	 * MenuManager饹󥹥ȥ饯
	 * @param sh
	 */
	public MenuManager(Shell sh) {
		this.shell = sh;
		actions = new Hashtable();
	}

	/**
	 * ˥塼СShell˥åȤ
	 */
	public void createMenuBar() {
		bar = new Menu(shell, SWT.BAR);
		shell.setMenuBar(bar);

		final MenuItem itemFile = new MenuItem(bar, SWT.CASCADE);
		final MenuItem itemEdit = new MenuItem(bar, SWT.CASCADE);
		final MenuItem itemSetting = new MenuItem(bar, SWT.CASCADE);
		final MenuItem itemHelp = new MenuItem(bar, SWT.CASCADE);
		
		itemFile.setText(resources.getMenuFile());
		itemEdit.setText(resources.getMenuEdit());
		itemSetting.setText(resources.getMenuSetting());
		itemHelp.setText(resources.getMenuHelp());

		itemFile.setMenu(createFileMenu());
		itemEdit.setMenu(createEditMenu());
		itemSetting.setMenu(createSettingMenu());
		itemHelp.setMenu(createHelpMenu());
		
		// ̾쥯κ
		createActionNamesSet();
	}	

	/**
	 * File˥塼˴ؤ륵֥˥塼κ
	 * @return Menu
	 */
	private Menu createFileMenu() {
		Menu menu = new Menu(shell, SWT.DROP_DOWN);
		
		itemFileNew = new MenuItem(menu, SWT.PUSH);
		itemFileNew.setText(resources.getItemFileNew());
		itemFileNew.setAccelerator(SWT.CTRL | 'N');

		new MenuItem(menu, SWT.SEPARATOR);

		itemFileOpen = new MenuItem(menu, SWT.PUSH);
		itemFileOpen.setText(resources.getItemFileOpen());
		itemFileOpen.setAccelerator(SWT.CTRL | 'O');

		itemFileClose = new MenuItem(menu, SWT.PUSH);
		itemFileClose.setText(resources.getItemFileClose());
		itemFileClose.setAccelerator(SWT.CTRL | 'W');
		
		itemFileSave = new MenuItem(menu, SWT.PUSH);
		itemFileSave.setText(resources.getItemFileSave());
		itemFileSave.setAccelerator(SWT.CTRL | 'S');

		itemFileSaveAs = new MenuItem(menu, SWT.PUSH);
		itemFileSaveAs.setText(resources.getItemFileSaveAs());

		new MenuItem(menu, SWT.SEPARATOR);

		itemFileExit = new MenuItem(menu, SWT.PUSH);
		itemFileExit.setText(resources.getItemFileExit());
		itemFileExit.setAccelerator(SWT.CTRL | 'Q');
		
		return menu;
	}
	
	/**
	 * Edit˥塼˴ؤ륵֥˥塼κ
	 * @return Menu
	 */
	private Menu createEditMenu() {
		Menu menu = new Menu(shell, SWT.DROP_DOWN);

		itemEditUndo = new MenuItem(menu, SWT.PUSH);
		itemEditUndo.setText(resources.getItemEditUndo());
		itemEditUndo.setAccelerator(SWT.CTRL | 'Z');

		itemEditRedo = new MenuItem(menu, SWT.PUSH);
		itemEditRedo.setText(resources.getItemEditRedo());
		itemEditRedo.setAccelerator(SWT.CTRL | 'Y');

		new MenuItem(menu, SWT.SEPARATOR);

		itemEditCut = new MenuItem (menu, SWT.PUSH);
		itemEditCut.setText(resources.getItemEditCut());

		itemEditCopy = new MenuItem (menu, SWT.PUSH);
		itemEditCopy.setText(resources.getItemEditCopy());

		itemEditPaste = new MenuItem (menu, SWT.PUSH);
		itemEditPaste.setText(resources.getItemEditPaste());

		return menu;
	}

	/**
	 * Setting˥塼˴ؤ륵֥˥塼κ
	 * @return Menu
	 */
	private Menu createSettingMenu() {
		Menu menu = new Menu(shell, SWT.DROP_DOWN);

		itemSettingFont = new MenuItem(menu, SWT.PUSH);
		itemSettingFont.setText(resources.getItemFont());

/////////////////////////////////////////////////////
  		MenuItem itemEncode = new MenuItem(menu, SWT.CASCADE);
  		itemEncode.setText(resources.getItemEncoding());

		MenuItem subitem;
		menuEncode = new Menu(shell, SWT.DROP_DOWN);
		for (int i = 0; i < es.getCount(); i++) {
			subitem = new MenuItem(menuEncode, SWT.RADIO);
			subitem.setText(es.getDispEncodeName(i));
		}
		itemEncode.setMenu(menuEncode);
////////////////////////////////////////////////////

		return menu;
	}

	/**
	 * Help˥塼˴ؤ륵֥˥塼κ
	 * @return Menu
	 */
	private Menu createHelpMenu() {
		Menu menu = new Menu(shell, SWT.DROP_DOWN);

		itemHelpAbout = new MenuItem(menu, SWT.NULL);
		itemHelpAbout.setText(resources.getItemHelpAbout());

		return menu;
	}

	/**
	 * ƥ˥塼ƥ˴Ϣդ̾򥳥쥯ɲ
	 */
	private void createActionNamesSet() {
		actions.put(itemFileNew, ActionNames.NEW);
		actions.put(itemFileOpen, ActionNames.OPEN);
		actions.put(itemFileClose, ActionNames.CLOSE);
		actions.put(itemFileSave, ActionNames.SAVE);
		actions.put(itemFileSaveAs, ActionNames.SAVEAS);
		actions.put(itemFileExit, ActionNames.EXIT);

		actions.put(itemEditUndo, ActionNames.UNDO);
		actions.put(itemEditRedo, ActionNames.REDO);
		actions.put(itemEditCut, ActionNames.CUT);
		actions.put(itemEditCopy, ActionNames.COPY);
		actions.put(itemEditPaste, ActionNames.PASTE);

		actions.put(itemSettingFont, ActionNames.FONT);


		MenuItem[] items = menuEncode.getItems();
		for (int i = 0; i < items.length; i++) {
			actions.put(items[i], ActionNames.ENCODE);
		}
		items[0].setSelection(true);


		actions.put(itemHelpAbout, ActionNames.ABOUT);
	}

	/**
	 * ƥ˥塼ƥ˥ꥹʡɲ
	 */
	public void addMenuSelectedListener() {
		itemFileNew.addSelectionListener(this);
		itemFileOpen.addSelectionListener(this);
		itemFileClose.addSelectionListener(this);
		itemFileSave.addSelectionListener(this);
		itemFileSaveAs.addSelectionListener(this);
		itemFileExit.addSelectionListener(this);

		itemEditUndo.addSelectionListener(this);
		itemEditRedo.addSelectionListener(this);
		itemEditCut.addSelectionListener(this);
		itemEditCopy.addSelectionListener(this);
		itemEditPaste.addSelectionListener(this);

		itemSettingFont.addSelectionListener(this);


		MenuItem[] items = menuEncode.getItems();
		for (int i = 0; i < items.length; i++) {
			items[i].addSelectionListener(this);
	  	}


		itemHelpAbout.addSelectionListener(this);
	}

	/**
	 * Receiverꤹ
	 */
	public void setReceiver(Receiver receiver) {
		this.receiver = receiver;
	}

	/**
	 * ǥեȤΤ
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
	}

	/**
	 * ˥塼ƥब򤵤줿ν
	 * ReceiverˤɤΥ˥塼ƥब򤵤줿ΤƤ餦
	 */
	public void widgetSelected(SelectionEvent e) {
		MenuItem mi= (MenuItem)e.getSource();
		receiver.actionHandler((String)actions.get(mi));
	}


	/**
	 * @return Menu Menu
	 */
	public Menu getMenu() {
		if (shell != null) return shell.getMenu();
		return null;
	}
	
	/**
	 * @return Menu MenuBar
	 */
	public Menu getMenuBar() {
		if (shell != null) return shell.getMenuBar();
		return null;
	}
	
	/**
	 * @return MenuItem ե뿷
	 */
	public MenuItem getItemFileNew() {
		return itemFileNew;
	}

	/**
	 * @return MenuItem ե볫
	 */
	public MenuItem getItemFileOpen() {
		return itemFileOpen;
	}

	/**
	 * @return MenuItem ե¸
	 */
	public MenuItem getItemFileSave() {
		return itemFileSave;
	}

	/**
	 * @return MenuItem ե̾դ¸
	 */
	public MenuItem getItemFileSaveAs() {
		return itemFileSaveAs;
	}

	/**
	 * @return MenuItem եĤ
	 */
	public MenuItem getItemFileClose() {
		return itemFileClose;
	}

	/**
	 * @return MenuItem ե뽪λ
	 */
	public MenuItem getItemFileExit() {
		return itemFileExit;
	}

	/**
	 * @return MenuItem ԽUndo
	 */
	public MenuItem getItemEditUndo() {
		return itemEditUndo;
	}

	/**
	 * @return MenuItem ԽRedo
	 */
	public MenuItem getItemEditRedo() {
		return itemEditRedo;
	}

	/**
	 * @return MenuItem Խԡ
	 */
	public MenuItem getItemEditCopy() {
		return itemEditCopy;
	}

	/**
	 * @return MenuItem Խڤ
	 */
	public MenuItem getItemEditCut() {
		return itemEditCut;
	}

	/**
	 * @return MenuItem ԽŽդ
	 */
	public MenuItem getItemEditPaste() {
		return itemEditPaste;
	}

	/**
	 * @return MenuItem ե
	 */
	public MenuItem getItemSettingFont() {
		return itemSettingFont;
	}

	/**
	 * @return MenuItem إץХ
	 */
	public MenuItem getItemHelpAbout() {
		return itemHelpAbout;
	}

	/**
	 * ߤΥ󥳡ǥ󥰤
	 * @return String
	 */
	public String getNowEncoding() {
		String result = null;
		MenuItem[] items = menuEncode.getItems();
		for (int i = 0; i < items.length; i++) {
			if (items[i].getSelection()) {
				result = es.getRealEncodeName(i);
				break;
			}
		}
		return result;
	}

}
