<?php
/*
  ◆祈祷師 (weather_priest)
  ○仕様
  ・司祭：天候発動 (2日目以降)
*/
RoleManager::LoadFile('priest');
class Role_weather_priest extends Role_priest {
  protected function IgnoreResult() {
    return DB::$ROOM->date < 2;
  }

  protected function IgnoreSetPriest() {
    if (DB::$ROOM->date < 3 || DB::$ROOM->date % 3 != 0) return true;
    return ! DB::$USER->IsLiveRole($this->role);
  }

  public function Priest() {
    $data = $this->GetStack('priest');

    //スキップ判定 (天変地異なら常時発動)
    if (! DB::$ROOM->IsOption('full_weather') && DB::$ROOM->date % 3 == 0 &&
	$data->count['total'] - $data->count['human_side'] <= $data->count['wolf'] * 2) {
      return false;
    }

    $list = $this->GetWeatherList(); //天候発動リスト
    //試行テスト
    //$stack = array(); for ($i = 0; $i < 20; $i++) @$stack[Lottery::Draw($list)]++;
    //ksort($stack); Text::p($stack);

    if (DB::$ROOM->IsOption('full_weather') && DB::$ROOM->IsDate(1)) { //天変地異対応
      DB::$ROOM->EntryWeather(Lottery::Draw($list), 1);
    }

    $weather = Lottery::Draw($list);
    //$weather = 44; //テスト用
    $date = 2;
    DB::$ROOM->EntryWeather($weather, $date, DB::$USER->IsLiveRole($this->role));
  }


  //天候発動リスト取得
  private function GetWeatherList(){
    $list = GameConfig::$weather_list;
    //Text::p($list, '◆WeatherList');

    $list = $this->CalibrationCamp($list);
    //Text::p($list, '◆Calibration/Camp');

    $list = $this->CalibrationRole($list);
    //Text::p($list, '◆Calibration/Role');

    return $list;
  }

  //陣営・投票余暇補正
  private function CalibrationCamp(array $list) {
    $data = $this->GetStack('priest');

    //投票余暇取得
    $stack = $data->count;
    $vote_margin = ceil(($stack['total'] - 2) / 2) - $stack['wolf'] - $stack['fox'];
    //Text::p($vote_margin, '◆VoteMargin');

    if ($stack['fox'] > $stack['wolf']) { //妖狐陣営優勢
      foreach (array(3, 8, 31, 36) as $id) {
	$list[$id] = ceil($list[$id] * 0.8);
      }
    }

    if ($vote_margin > 2) { //村人陣営優勢
      foreach (array(17, 18, 20, 23, 30, 33, 35, 37, 41, 45, 47) as $id) {
	$list[$id] = ceil($list[$id] * 1.2);
      }
      foreach (array(6, 7, 9, 16, 22, 32, 34, 46) as $id) {
	$list[$id] = ceil($list[$id] * 0.8);
      }
    }
    elseif ($vote_margin < 1) { //村人陣営劣勢
      foreach (array(6, 7, 8, 9, 32, 34, 42, 46) as $id) {
	$list[$id] = ceil($list[$id] * 1.2);
      }
      foreach (array(4, 5, 17, 18, 23, 33, 37, 39, 45, 47) as $id) {
	$list[$id] = ceil($list[$id] * 0.8);
      }
    }

    return $list;
  }

  //生存役職補正
  private function CalibrationRole(array $list) {
    $calib_off_list = array(
      'detective_common' => array(5, 15, 41)
    );

    $calib_role_list = array(
      'human'              => 24,
      'suspect'            => 42,
      'critical_mage'      =>  4,
      'bacchus_medium'     => 21,
      'critical_jealousy'  =>  4,
      'brownie'            => 24,
      'revive_brownie'     => 22,
      'cursed_brownie'     => 17,
      'mad'                => 60,
      'swindle_mad'        => 60,
      'jammer_mad'         => 36,
      'trap_mad'           => 37,
      'snow_trap_mad'      => 33,
      'corpse_courier_mad' => 45,
      'amaze_mad'          =>  2,
      'critical_mad'       =>  4,
      'follow_mad'         => 17,
      'critical_fox'       =>  4,
      'critical_avenger'   =>  4
    );

    $calib_group_list = array(
      'cute'     => 42,
      'jeasouly' => 27,
      'depraver' =>  3,
      'vampire'  => 40,
      'fairy'    => 29
    );

    foreach (DB::$USER->role as $role => $stack) {
      $calib_id = null;
      if (array_key_exists($role, $calib_off_list)) {
	foreach ($calib_off_list[$role] as $calib_off_id) {
	  $list[$calib_off_id] = 0;
	}
      }

      if (array_key_exists($role, $calib_role_list)) {
	$calib_id = $calib_role_list[$role];
      }

      foreach ($calib_group_list as $group => $id) {
	if (strpos($role, $group) !== false) {
	  $calib_id = $id;
	  break;
	}
      }
      //Text::p($role, "◆WeatherCalib [{$calib_id}]");

      if (isset($calib_id)) {
	$count = 0;
	foreach ($stack as $id) {
	  if (DB::$USER->ByID($id)->IsLive(true)) $count++;
	}
	$list[$calib_id] = ceil($list[$calib_id] * (1 + $count * 0.1));
      }
    }

    return $list;
  }
}
