/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import jp.osdn.jindolf.parser.content.DecodeErrorInfo;
import jp.osdn.jindolf.parser.content.DecodedContent;
import jp.sourceforge.jindolf.archiver.VillageData;
import jp.sourceforge.jindolf.archiver.Win31j;

public class XmlOut
implements Appendable,
Flushable,
Closeable {
    private static final String ORIG_DTD = "http://jindolf.sourceforge.jp/xml/dtd/bbsArchive-110421.dtd";
    private static final String ORIG_NS = "http://jindolf.sourceforge.jp/xml/ns/501";
    private static final String ORIG_SCHEME = "http://jindolf.sourceforge.jp/xml/xsd/bbsArchive-110421.xsd";
    private static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private static final char BS_CHAR = '\\';
    private static final char SQ_CHAR = '\'';
    private static final char DQ_CHAR = '\"';
    private static final char TILDE_CHAR = '~';
    private static final char DELETE_CHAR = '\u007f';
    private static final char YEN_CHAR = '\u00a5';
    private static final char OVERLINE_CHAR = '\u203e';
    private static final char SYMNULL_CHAR = '\u2400';
    private static final char SYMDELETE_CHAR = '\u2421';
    private static final char REP_CHAR = '\ufffd';
    private static final String INDENT_UNIT = "  ";
    private static final String FORM_XSD_DATETIME = "{0,number,#0000}-{1,number,#00}-{2,number,#00}T{3,number,#00}:{4,number,#00}:{5,number,#00}.{6,number,#000}+09:00";
    private static final TimeZone TZ_TOKYO = TimeZone.getTimeZone("Asia/Tokyo");
    private static final Charset CS_DEF = Charset.forName("Shift_JIS");
    private static final char[] HEX_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final Writer writer;
    private String charsetName;
    private boolean isShiftJis;

    XmlOut(Writer writer) {
        this.writer = writer;
        this.setSourceCharsetImpl(CS_DEF);
    }

    public static boolean isWhiteSpace(char chVal) {
        switch (chVal) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static boolean isXmlChar(char chVal) {
        if (' ' <= chVal && chVal <= '\ud7ff') {
            return true;
        }
        if ('\ue000' <= chVal && chVal <= '\ufffd') {
            return true;
        }
        if (chVal == '\t' || chVal == '\n' || chVal == '\r') {
            return true;
        }
        return Character.isSurrogate(chVal);
    }

    public static char replaceChar(char chVal) {
        char result = '\u0000' <= chVal && chVal <= '\u001f' ? (char)(chVal + 9216) : (chVal == '\u007f' ? (char)'\u2421' : '\ufffd');
        return result;
    }

    public static String toHex(byte bVal) {
        int hexVal = bVal & 0xFF;
        char ch1 = HEX_TABLE[hexVal & 0xF];
        char ch0 = HEX_TABLE[(hexVal >>= 4) & 0xF];
        StringBuilder txt = new StringBuilder();
        txt.append(ch0);
        txt.append(ch1);
        return txt.toString();
    }

    public static String toHex(char cVal) {
        int hexVal = cVal & 0xFFFF;
        char ch3 = HEX_TABLE[hexVal & 0xF];
        char ch2 = HEX_TABLE[(hexVal >>= 4) & 0xF];
        char ch1 = HEX_TABLE[(hexVal >>= 4) & 0xF];
        char ch0 = HEX_TABLE[(hexVal >>= 4) & 0xF];
        StringBuilder txt = new StringBuilder();
        if (cVal > '\u00ff') {
            txt.append(ch0);
            txt.append(ch1);
        }
        txt.append(ch2);
        txt.append(ch3);
        return txt.toString();
    }

    public static String toHex(short sVal) {
        int hexVal = sVal & 0xFFFF;
        char ch3 = HEX_TABLE[hexVal & 0xF];
        char ch2 = HEX_TABLE[(hexVal >>= 4) & 0xF];
        char ch1 = HEX_TABLE[(hexVal >>= 4) & 0xF];
        char ch0 = HEX_TABLE[(hexVal >>= 4) & 0xF];
        StringBuilder txt = new StringBuilder();
        txt.append(ch0);
        txt.append(ch1);
        txt.append(ch2);
        txt.append(ch3);
        return txt.toString();
    }

    public void setSourceCharset(Charset cs) {
        this.setSourceCharsetImpl(cs);
    }

    private void setSourceCharsetImpl(Charset cs) {
        this.charsetName = cs.name();
        this.isShiftJis = "Shift_JIS".equals(this.charsetName);
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        this.writer.append(csq);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        this.writer.append(csq, start, end);
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.writer.append(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void sp() throws IOException {
        this.append(' ');
    }

    public void nl() throws IOException {
        this.append('\n');
    }

    public void indent(int level) throws IOException {
        for (int ct = 1; ct <= level; ++ct) {
            this.append(INDENT_UNIT);
        }
    }

    public void charRefOut(char chVal) throws IOException {
        String hex = XmlOut.toHex(chVal);
        this.append("&#x");
        this.append(hex);
        this.append(";");
    }

    public void attrOut(CharSequence name, CharSequence value) throws IOException {
        this.append(name);
        this.append('=');
        this.append('\"');
        this.attrValOut(value);
        this.append('\"');
    }

    private void attrValOut(CharSequence value) throws IOException {
        int len = value.length();
        block7: for (int pos = 0; pos < len; ++pos) {
            char chVal = value.charAt(pos);
            switch (chVal) {
                case '&': {
                    this.append("&amp;");
                    continue block7;
                }
                case '<': {
                    this.append("&lt;");
                    continue block7;
                }
                case '>': {
                    this.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    this.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    this.append("&apos;");
                    continue block7;
                }
                default: {
                    this.append(chVal);
                }
            }
        }
    }

    public void timeAttrOut(CharSequence name, int hour, int minute) throws IOException {
        this.append(name);
        this.append('=');
        this.append('\"');
        this.digi2colOut(hour);
        this.append(':');
        this.digi2colOut(minute);
        this.append(":00+09:00");
        this.append('\"');
    }

    public void dateAttrOut(CharSequence name, int month, int day) throws IOException {
        this.append(name);
        this.append('=');
        this.append('\"');
        this.append("--");
        this.digi2colOut(month);
        this.append('-');
        this.digi2colOut(day);
        this.append("+09:00");
        this.append('\"');
    }

    private void digi2colOut(int digit) throws IOException {
        int col2 = Math.abs(digit) % 100;
        char ch1st = (char)(48 + col2 / 10);
        char ch2nd = (char)(48 + col2 % 10);
        this.append(ch1st);
        this.append(ch2nd);
    }

    public void dateTimeAttr(CharSequence name, long epochMs) throws IOException {
        GregorianCalendar calendar = new GregorianCalendar(TZ_TOKYO);
        calendar.setTimeInMillis(epochMs);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int sec = calendar.get(13);
        int msec = calendar.get(14);
        String attrVal = MessageFormat.format(FORM_XSD_DATETIME, year, month, day, hour, minute, sec, msec);
        this.attrOut(name, attrVal);
    }

    public void dumpDecodedContent(DecodedContent content) throws IOException {
        if (!content.hasDecodeError()) {
            this.charDataOut(content);
            return;
        }
        int last = 0;
        List<DecodeErrorInfo> errList = content.getDecodeErrorList();
        for (DecodeErrorInfo err : errList) {
            int charPos = err.getCharPosition();
            CharSequence line = content.subSequence(last, charPos);
            this.charDataOut(line);
            this.dumpErrorInfo(err);
            last = charPos + 1;
        }
        CharSequence line = content.subSequence(last, content.length());
        this.charDataOut(line);
    }

    public void dumpErrorInfo(DecodeErrorInfo errorInfo) throws IOException {
        if (this.isShiftJis && errorInfo.has2nd()) {
            byte bVal1 = errorInfo.getRawByte1st();
            byte bVal2 = errorInfo.getRawByte2nd();
            this.dumpSjisMapError(bVal1, bVal2);
        } else {
            byte bVal1 = errorInfo.getRawByte1st();
            this.dumpDecodeError(bVal1);
            if (errorInfo.has2nd()) {
                byte bVal2 = errorInfo.getRawByte2nd();
                this.dumpDecodeError(bVal2);
            }
        }
    }

    public void dumpSjisMapError(byte bVal1, byte bVal2) throws IOException {
        short hexVal = (short)(bVal1 & 0xFF);
        hexVal = (short)(hexVal << 8);
        hexVal = (short)(hexVal | (short)(bVal2 & 0xFF));
        String hexBin = XmlOut.toHex(hexVal);
        char replaceChar = Win31j.getWin31jChar(bVal1, bVal2);
        this.rawDataOut(hexBin, replaceChar);
    }

    public void dumpDecodeError(byte bVal) throws IOException {
        String hexBin = XmlOut.toHex(bVal);
        char replaceChar = XmlOut.replaceChar((char)(bVal & 0xFF));
        this.rawDataOut(hexBin, replaceChar);
    }

    private void rawDataOut(String hex, char replace) throws IOException {
        this.append("<rawdata");
        String encName = this.charsetName;
        this.sp();
        this.attrOut("encoding", encName);
        this.sp();
        this.attrOut("hexBin", hex);
        this.sp();
        this.append(">");
        this.append(replace);
        this.append("</rawdata>");
    }

    public void charDataOut(CharSequence seq) throws IOException {
        int len = seq.length();
        boolean leadSpace = false;
        for (int pos = 0; pos < len; ++pos) {
            char chVal = seq.charAt(pos);
            if (XmlOut.isWhiteSpace(chVal)) {
                boolean isLastPos;
                boolean is1stPos = pos == 0;
                boolean bl = isLastPos = pos >= len - 1;
                if (is1stPos || isLastPos || leadSpace) {
                    this.charRefOut(chVal);
                } else if (chVal != ' ') {
                    this.charRefOut(chVal);
                } else {
                    this.append(chVal);
                }
                leadSpace = true;
                continue;
            }
            this.nonSpaceOut(chVal);
            leadSpace = false;
        }
    }

    private void nonSpaceOut(char chVal) throws IOException {
        if (chVal == '&') {
            this.append("&amp;");
        } else if (chVal == '<') {
            this.append("&lt;");
        } else if (chVal == '>') {
            this.append("&gt;");
        } else if (chVal == '\"') {
            this.append("&quot;");
        } else if (chVal == '\'') {
            this.append("&apos;");
        } else if (chVal == '\\') {
            this.append('\u00a5');
        } else if (chVal == '~') {
            this.append('\u203e');
        } else if (!XmlOut.isXmlChar(chVal)) {
            this.dumpRawData(chVal);
        } else {
            this.append(chVal);
        }
    }

    public void dumpRawData(char chVal) throws IOException {
        String hexBin = XmlOut.toHex(chVal);
        char replaceChar = XmlOut.replaceChar(chVal);
        this.rawDataOut(hexBin, replaceChar);
    }

    public void dumpVillageData(VillageData villageData) throws IOException {
        this.append("<?xml");
        this.sp();
        this.attrOut("version", "1.0");
        this.sp();
        this.attrOut("encoding", "UTF-8");
        this.sp();
        this.append("?>");
        this.nl();
        this.nl();
        this.append("<!--");
        this.nl();
        this.indent(1);
        this.append("\u4eba\u72fcBBS\u30a2\u30fc\u30ab\u30a4\u30d6");
        this.nl();
        this.indent(1);
        this.append("http://jindolf.osdn.jp/");
        this.nl();
        this.append("-->");
        this.nl();
        this.nl();
        this.dumpDocType();
        this.nl();
        this.nl();
        villageData.dumpXml(this);
        this.nl();
        this.append("<!-- EOF -->");
        this.nl();
        this.flush();
    }

    public void dumpDocType() throws IOException {
        this.append("<!DOCTYPE village SYSTEM");
        this.sp();
        this.append('\"');
        this.append(ORIG_DTD);
        this.append('\"');
        this.sp();
        this.append(">");
    }

    public void dumpNameSpaceDecl() throws IOException {
        this.attrOut("xmlns", ORIG_NS);
    }

    public void dumpSiNameSpaceDecl() throws IOException {
        this.attrOut("xmlns:xsi", SCHEMA_NS);
    }

    public void dumpSchemeLocation() throws IOException {
        this.attrOut("xsi:schemaLocation", "http://jindolf.sourceforge.jp/xml/ns/501 http://jindolf.sourceforge.jp/xml/xsd/bbsArchive-110421.xsd");
    }
}

