/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jp.osdn.jindolf.parser.content.DecodedContent;
import jp.sourceforge.jindolf.archiver.XmlOut;

public abstract class TopicData {
    private static final DecodedContent BREAK = new DecodedContent("\n");
    private final List<DecodedContent> lineList = new LinkedList<DecodedContent>();

    protected TopicData() {
    }

    public void addLine(DecodedContent content) {
        this.lineList.add(content);
    }

    public void addBreak() {
        this.lineList.add(BREAK);
    }

    public int getLineNum() {
        return this.lineList.size();
    }

    public DecodedContent get1stLine() {
        return this.lineList.get(0);
    }

    public void dumpLines(XmlOut writer) throws IOException {
        DecodedContent lastLine = null;
        DecodedContent lastContent = null;
        Iterator<DecodedContent> iterator = this.lineList.iterator();
        while (iterator.hasNext()) {
            DecodedContent content;
            lastContent = content = iterator.next();
            if (content == BREAK) {
                if (lastLine != null) {
                    writer.append("</li>");
                    lastLine = null;
                } else {
                    writer.append("<li/>");
                }
                writer.nl();
                continue;
            }
            if (lastLine == null) {
                writer.append("<li>");
            }
            writer.dumpDecodedContent(content);
            lastLine = content;
        }
        if (lastLine != null) {
            writer.append("</li>");
        } else if (lastContent == BREAK) {
            writer.append("<li/>");
        }
        writer.nl();
    }

    public abstract void dumpXml(XmlOut var1) throws IOException;
}

