/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jp.sourceforge.jindolf.archiver.LandUtils;
import jp.sourceforge.jindolf.archiver.OptArg;
import jp.sourceforge.jindolf.corelib.LandDef;

public final class OptInfo {
    private static final String FMT_INVOPT = "\u4e0d\u6b63\u306a\u30aa\u30d7\u30b7\u30e7\u30f3\u3067\u3059\u3002 {0}";
    private static final String FMT_NOARG = "\u30aa\u30d7\u30b7\u30e7\u30f3 {0} \u306b\u5f15\u6570\u304c\u3042\u308a\u307e\u305b\u3093\u3002";
    private static final String FMT_INVVID = "\u4e0d\u6b63\u306a\u6751\u756a\u53f7\u3067\u3059\u3002 {0}";
    private static final String FMT_INVLID = "\u4e0d\u6b63\u306a\u56fd\u8b58\u5225\u5b50\u3067\u3059\u3002 {0}";
    private static final String MSG_NOLID = "-land \u30aa\u30d7\u30b7\u30e7\u30f3\u3067\u56fd\u8b58\u5225\u5b50\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    private static final String MSG_NOVID = "-vid \u30aa\u30d7\u30b7\u30e7\u30f3\u3067\u6751\u756a\u53f7\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    private static final String MSG_EXCOUT = "-outdir \u304b -stdout \u306e\u3069\u3061\u3089\u304b\u4e00\u65b9\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    private boolean isHelp = false;
    private LandDef landDef = null;
    private int vid = -1;
    private boolean isStdout = false;
    private String outDir = null;
    private String errMsg = null;

    private OptInfo() {
    }

    public static OptInfo parseOptInfo(String ... args) {
        List<String> argList = Arrays.asList(args);
        return OptInfo.parseOptInfo(argList);
    }

    public static OptInfo parseOptInfo(List<String> argList) {
        OptInfo optInfo = new OptInfo();
        if (argList.isEmpty()) {
            optInfo.isHelp = true;
            return optInfo;
        }
        Iterator<String> it = argList.iterator();
        while (it.hasNext()) {
            String arg = it.next();
            OptArg optArg = OptArg.parseOptArg(arg);
            if (optArg == null) {
                optInfo.errMsg = MessageFormat.format(FMT_INVOPT, arg);
                break;
            }
            boolean isNoArgOpt = optInfo.applyDepOpt(optArg);
            if (optInfo.isHelp()) break;
            if (isNoArgOpt) continue;
            if (!it.hasNext()) {
                optInfo.errMsg = MessageFormat.format(FMT_NOARG, arg);
                break;
            }
            String val = it.next();
            optInfo.applyOptWithVal(optArg, val);
            if (!optInfo.hasError()) continue;
            break;
        }
        if (optInfo.isHelp() || optInfo.hasError()) {
            return optInfo;
        }
        optInfo.condErrCheck();
        return optInfo;
    }

    private boolean applyDepOpt(OptArg opt) {
        boolean isNoArgOpt = true;
        switch (opt) {
            case OPT_HELP: {
                this.isHelp = true;
                break;
            }
            case OPT_STDOUT: {
                this.isStdout = true;
                this.outDir = null;
                break;
            }
            default: {
                isNoArgOpt = false;
            }
        }
        return isNoArgOpt;
    }

    private void applyOptWithVal(OptArg opt, String val) {
        switch (opt) {
            case OPT_LAND: {
                this.landDef = LandUtils.getLandDef(val);
                if (this.getLandDef() != null) break;
                this.errMsg = MessageFormat.format(FMT_INVLID, val);
                break;
            }
            case OPT_VID: {
                try {
                    this.vid = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    this.vid = -1;
                }
                if (this.getVid() >= 0) break;
                this.errMsg = MessageFormat.format(FMT_INVVID, val);
                break;
            }
            case OPT_OUTDIR: {
                this.outDir = val;
                this.isStdout = false;
                break;
            }
        }
    }

    private void condErrCheck() {
        String msg = null;
        if (this.getLandDef() == null) {
            msg = MSG_NOLID;
        } else if (this.getVid() < 0) {
            msg = MSG_NOVID;
        } else if (!this.isSingleOut()) {
            msg = MSG_EXCOUT;
        }
        if (msg != null) {
            this.errMsg = msg;
        }
    }

    private boolean isSingleOut() {
        boolean exclusiveCase = this.getOutdir() != null ^ this.isStdout();
        return exclusiveCase;
    }

    public boolean isHelp() {
        return this.isHelp;
    }

    public LandDef getLandDef() {
        return this.landDef;
    }

    public int getVid() {
        return this.vid;
    }

    public boolean isStdout() {
        return this.isStdout;
    }

    public String getOutdir() {
        return this.outDir;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public boolean hasError() {
        if (this.isHelp) {
            return false;
        }
        return this.errMsg != null;
    }
}

