/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import jp.sourceforge.jindolf.archiver.MultiPlexer;
import org.xml.sax.SAXException;

public class ValidateTask
implements Runnable {
    private static final SchemaFactory FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private final Validator validator;
    private final Source source;

    protected ValidateTask(Reader reader) throws SAXException {
        Schema schema = FACTORY.newSchema();
        this.validator = schema.newValidator();
        this.source = new StreamSource(reader);
    }

    public void run() {
        try {
            this.validator.validate(this.source);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.err.println("XML\u691c\u8a3c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            System.exit(1);
        }
    }

    public static Writer wrapValidator(Writer writer) {
        ValidateTask task;
        PipedWriter pipeWriter;
        PipedReader reader = new PipedReader();
        try {
            pipeWriter = new PipedWriter(reader);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.err.println("\u51e6\u7406\u3092\u7d9a\u884c\u3067\u304d\u307e\u305b\u3093\u3002");
            System.exit(1);
            return null;
        }
        MultiPlexer mtplx = new MultiPlexer();
        mtplx.addWriter(writer);
        mtplx.addWriter(pipeWriter);
        try {
            task = new ValidateTask(reader);
        }
        catch (SAXException e) {
            e.printStackTrace(System.err);
            System.err.println("\u51e6\u7406\u3092\u7d9a\u884c\u3067\u304d\u307e\u305b\u3093\u3002");
            System.exit(1);
            return null;
        }
        Thread th = new Thread(task);
        th.setDaemon(false);
        th.start();
        return mtplx;
    }
}

