/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Village;

public class VillageIconRenderer
extends DefaultTreeCellRenderer {
    private static final ImageIcon ICON_PROLOGUE;
    private static final ImageIcon ICON_PROGRESS;
    private static final ImageIcon ICON_EPILOGUE;
    private static final ImageIcon ICON_GAMEOVER;
    private static final ImageIcon ICON_INVALID;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (leaf && value instanceof Village) {
            Village village = (Village)value;
            ImageIcon icon = null;
            switch (village.getState()) {
                case PROLOGUE: {
                    icon = ICON_PROLOGUE;
                    break;
                }
                case PROGRESS: {
                    icon = ICON_PROGRESS;
                    break;
                }
                case EPILOGUE: {
                    icon = ICON_EPILOGUE;
                    break;
                }
                case GAMEOVER: {
                    icon = ICON_GAMEOVER;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (!village.isValid()) {
                icon = ICON_INVALID;
            }
            this.setLeafIcon(icon);
        }
        Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        return comp;
    }

    static {
        URL url = Jindolf.getResource("resources/image/prologue.png");
        ICON_PROLOGUE = new ImageIcon(url);
        url = Jindolf.getResource("resources/image/progress.png");
        ICON_PROGRESS = new ImageIcon(url);
        url = Jindolf.getResource("resources/image/epilogue.png");
        ICON_EPILOGUE = new ImageIcon(url);
        url = Jindolf.getResource("resources/image/gameover.png");
        ICON_GAMEOVER = new ImageIcon(url);
        url = Jindolf.getResource("resources/image/cross.png");
        ICON_INVALID = new ImageIcon(url);
    }
}

