/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.FaceIconSet;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Player;
import jp.sourceforge.jindolf.SysEvent;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.Village;
import jp.sourceforge.jindolf.WolfBBS;
import jp.sourceforge.jindolf.corelib.Destiny;
import jp.sourceforge.jindolf.corelib.GameRole;
import jp.sourceforge.jindolf.corelib.SysEventType;
import jp.sourceforge.jindolf.corelib.Team;
import jp.sourceforge.jindolf.corelib.VillageState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameSummary {
    public static final Comparator<Player> COMPARATOR_CASTING = new CastingComparator();
    private final Map<Avatar, Player> playerMap = new HashMap<Avatar, Player>();
    private final List<Player> playerList = new LinkedList<Player>();
    private final Map<SysEventType, List<SysEvent>> eventMap = new EnumMap<SysEventType, List<SysEvent>>(SysEventType.class);
    private final Village village;
    private Team winner;
    private int ctScryVillage = 0;
    private int ctScryHamster = 0;
    private int ctScryMadman = 0;
    private int ctScryWolf = 0;
    private int ctGuardVillage = 0;
    private int ctGuardHamster = 0;
    private int ctGuardMadman = 0;
    private int ctGuardWolf = 0;
    private int ctGuardVillageGJ = 0;
    private int ctGuardHamsterGJ = 0;
    private int ctGuardMadmanGJ = 0;
    private int ctGuardFakeGJ = 0;
    private long talk1stTimeMs = -1L;
    private long talkLastTimeMs = -1L;

    public static String getRoleBalanceSequence(List<Player> players) {
        LinkedList<GameRole> roleList = new LinkedList<GameRole>();
        for (Player player : players) {
            GameRole role = player.getRole();
            roleList.add(role);
        }
        Collections.sort(roleList, GameRole.getPowerBalanceComparator());
        StringBuilder result = new StringBuilder();
        for (GameRole role : roleList) {
            char ch = role.getShortName();
            result.append(ch);
        }
        return result.toString();
    }

    public GameSummary(Village village) {
        VillageState state = village.getState();
        if (state != VillageState.EPILOGUE && state != VillageState.GAMEOVER) {
            throw new IllegalStateException();
        }
        this.village = village;
        this.summarize();
    }

    private void summarize() {
        this.buildEventMap();
        this.summarizeTime();
        this.summarizeWinner();
        this.summarizePlayers();
        for (Period period : this.village.getPeriodList()) {
            this.summarizePeriod(period);
        }
        this.summarizeJudge();
        this.summarizeGuard();
    }

    private void buildEventMap() {
        for (SysEventType type : SysEventType.values()) {
            LinkedList eventList = new LinkedList();
            this.eventMap.put(type, eventList);
        }
        for (Period period : this.village.getPeriodList()) {
            for (Topic topic : period.getTopicList()) {
                if (!(topic instanceof SysEvent)) continue;
                SysEvent event = (SysEvent)topic;
                SysEventType type = event.getSysEventType();
                List<SysEvent> eventList = this.eventMap.get((Object)type);
                eventList.add(event);
            }
        }
    }

    private void summarizeWinner() {
        List<SysEvent> eventList = this.eventMap.get((Object)SysEventType.WINVILLAGE);
        if (!eventList.isEmpty()) {
            this.winner = Team.VILLAGE;
        }
        if (!(eventList = this.eventMap.get((Object)SysEventType.WINWOLF)).isEmpty()) {
            this.winner = Team.WOLF;
        }
        if (!(eventList = this.eventMap.get((Object)SysEventType.WINHAMSTER)).isEmpty()) {
            this.winner = Team.HAMSTER;
        }
        if (this.winner == null) assert (false);
    }

    private void summarizePlayers() {
        List<Integer> integerList;
        List<Avatar> avatarList;
        List<SysEvent> eventList = this.eventMap.get((Object)SysEventType.ONSTAGE);
        for (SysEvent event : eventList) {
            avatarList = event.getAvatarList();
            integerList = event.getIntegerList();
            Avatar onstageAvatar = avatarList.get(0);
            Player onstagePlayer = this.registPlayer(onstageAvatar);
            onstagePlayer.setEntryNo(integerList.get(0));
        }
        eventList = this.eventMap.get((Object)SysEventType.PLAYERLIST);
        assert (eventList.size() == 1);
        SysEvent event = eventList.get(0);
        avatarList = event.getAvatarList();
        List<GameRole> roleList = event.getRoleList();
        integerList = event.getIntegerList();
        List<CharSequence> textList = event.getCharSequenceList();
        int avatarNum = avatarList.size();
        for (int idx = 0; idx < avatarNum; ++idx) {
            Avatar avatar = avatarList.get(idx);
            GameRole role = roleList.get(idx);
            CharSequence urlText = textList.get(idx * 2);
            CharSequence idName = textList.get(idx * 2 + 1);
            int liveOrDead = integerList.get(idx);
            Player player = this.registPlayer(avatar);
            player.setRole(role);
            player.setUrlText(((Object)urlText).toString());
            player.setIdName(((Object)idName).toString());
            if (liveOrDead != 0) {
                player.setObitDay(-1);
                player.setDestiny(Destiny.ALIVE);
            }
            this.playerList.add(player);
        }
    }

    private void summarizePeriod(Period period) {
        int day = period.getDay();
        for (Topic topic : period.getTopicList()) {
            if (!(topic instanceof SysEvent)) continue;
            SysEvent sysEvent = (SysEvent)topic;
            this.summarizeDestiny(day, sysEvent);
        }
    }

    private void summarizeDestiny(int day, SysEvent sysEvent) {
        List<Avatar> avatarList = sysEvent.getAvatarList();
        List<Integer> integerList = sysEvent.getIntegerList();
        int avatarTotal = avatarList.size();
        Avatar lastAvatar = null;
        if (avatarTotal > 0) {
            lastAvatar = avatarList.get(avatarTotal - 1);
        }
        SysEventType eventType = sysEvent.getSysEventType();
        switch (eventType) {
            case EXECUTION: {
                if (integerList.get(avatarTotal - 1) > 0) break;
                Player executedPl = this.registPlayer(lastAvatar);
                executedPl.setDestiny(Destiny.EXECUTED);
                executedPl.setObitDay(day);
                break;
            }
            case SUDDENDEATH: {
                Avatar suddenDeathAvatar = avatarList.get(0);
                Player suddenDeathPlayer = this.registPlayer(suddenDeathAvatar);
                suddenDeathPlayer.setDestiny(Destiny.SUDDENDEATH);
                suddenDeathPlayer.setObitDay(day);
                break;
            }
            case COUNTING: {
                if (avatarTotal % 2 == 0) break;
                Player executedPlayer = this.registPlayer(lastAvatar);
                executedPlayer.setDestiny(Destiny.EXECUTED);
                executedPlayer.setObitDay(day);
                break;
            }
            case MURDERED: {
                for (Avatar avatar : avatarList) {
                    Player player = this.registPlayer(avatar);
                    player.setDestiny(Destiny.EATEN);
                    player.setObitDay(day);
                }
                break;
            }
        }
    }

    private void summarizeTime() {
        for (Period period : this.village.getPeriodList()) {
            for (Topic topic : period.getTopicList()) {
                if (!(topic instanceof Talk)) continue;
                Talk talk = (Talk)topic;
                long epoch = talk.getTimeFromID();
                if (this.talk1stTimeMs < 0L) {
                    this.talk1stTimeMs = epoch;
                }
                if (this.talkLastTimeMs < 0L) {
                    this.talkLastTimeMs = epoch;
                }
                if (epoch < this.talk1stTimeMs) {
                    this.talk1stTimeMs = epoch;
                }
                if (epoch <= this.talkLastTimeMs) continue;
                this.talkLastTimeMs = epoch;
            }
        }
    }

    private void summarizeJudge() {
        List<SysEvent> eventList = this.eventMap.get((Object)SysEventType.JUDGE);
        block5: for (SysEvent event : eventList) {
            List<Avatar> avatarList = event.getAvatarList();
            Avatar avatar = avatarList.get(1);
            Player seered = this.getPlayer(avatar);
            GameRole role = seered.getRole();
            switch (role) {
                case WOLF: {
                    ++this.ctScryWolf;
                    continue block5;
                }
                case MADMAN: {
                    ++this.ctScryMadman;
                    continue block5;
                }
                case HAMSTER: {
                    ++this.ctScryHamster;
                    continue block5;
                }
            }
            ++this.ctScryVillage;
        }
    }

    public CharSequence dumpSeerActivity() {
        StringBuilder result = new StringBuilder();
        if (this.ctScryVillage > 0) {
            result.append("\u6751\u9663\u55b6\u3092");
            result.append(this.ctScryVillage);
            result.append("\u56de");
        }
        if (this.ctScryHamster > 0) {
            if (result.length() > 0) {
                result.append('\u3001');
            }
            result.append("\u30cf\u30e0\u30b9\u30bf\u30fc\u3092");
            result.append(this.ctScryHamster);
            result.append("\u56de");
        }
        if (this.ctScryMadman > 0) {
            if (result.length() > 0) {
                result.append('\u3001');
            }
            result.append("\u72c2\u4eba\u3092");
            result.append(this.ctScryMadman);
            result.append("\u56de");
        }
        if (this.ctScryWolf > 0) {
            if (result.length() > 0) {
                result.append('\u3001');
            }
            result.append("\u4eba\u72fc\u3092");
            result.append(this.ctScryWolf);
            result.append("\u56de");
        }
        if (result.length() <= 0) {
            result.append("\u8ab0\u3082\u5360\u308f\u306a\u304b\u3063\u305f\u3002");
        } else {
            result.append("\u5360\u3063\u305f\u3002");
        }
        CharSequence seq = WolfBBS.escapeWikiSyntax(result);
        return seq;
    }

    private void summarizeGuard() {
        List<SysEvent> eventList = this.eventMap.get((Object)SysEventType.GUARD);
        block5: for (SysEvent event : eventList) {
            List<Avatar> avatarList = event.getAvatarList();
            Avatar avatar = avatarList.get(1);
            Player guarded = this.getPlayer(avatar);
            GameRole guardedRole = guarded.getRole();
            switch (guardedRole) {
                case WOLF: {
                    ++this.ctGuardWolf;
                    continue block5;
                }
                case MADMAN: {
                    ++this.ctGuardMadman;
                    continue block5;
                }
                case HAMSTER: {
                    ++this.ctGuardHamster;
                    continue block5;
                }
            }
            ++this.ctGuardVillage;
        }
        for (Period period : this.village.getPeriodList()) {
            this.summarizeGjPeriod(period);
        }
    }

    private void summarizeGjPeriod(Period period) {
        if (period.getDay() <= 2) {
            return;
        }
        boolean hasAssaultTried = period.hasAssaultTried();
        boolean hunterAlive = false;
        int wolfNum = 0;
        Set<Avatar> voters = period.getVoterSet();
        for (Avatar avatar : voters) {
            Player player = this.getPlayer(avatar);
            switch (player.getRole()) {
                case HUNTER: {
                    hunterAlive = true;
                    break;
                }
                case WOLF: {
                    ++wolfNum;
                    break;
                }
            }
        }
        Avatar executed = period.getExecutedAvatar();
        if (executed != null) {
            Player player = this.getPlayer(executed);
            switch (player.getRole()) {
                case HUNTER: {
                    hunterAlive = false;
                    break;
                }
                case WOLF: {
                    --wolfNum;
                    break;
                }
            }
        }
        if (!hunterAlive || wolfNum <= 0) {
            return;
        }
        SysEvent sysEvent = period.getTypedSysEvent(SysEventType.NOMURDER);
        if (sysEvent == null) {
            return;
        }
        sysEvent = period.getTypedSysEvent(SysEventType.GUARD);
        if (sysEvent == null) {
            return;
        }
        if (hasAssaultTried) {
            Avatar guarded = sysEvent.getAvatarList().get(1);
            Player guardedPlayer = this.getPlayer(guarded);
            GameRole guardedRole = guardedPlayer.getRole();
            switch (guardedRole) {
                case MADMAN: {
                    ++this.ctGuardMadmanGJ;
                    break;
                }
                case HAMSTER: {
                    ++this.ctGuardHamsterGJ;
                    break;
                }
                default: {
                    ++this.ctGuardVillageGJ;
                    break;
                }
            }
        } else {
            ++this.ctGuardFakeGJ;
        }
    }

    public CharSequence dumpHunterActivity() {
        StringBuilder result = new StringBuilder();
        String atLeast = this.ctGuardFakeGJ > 0 ? "\u5c11\u306a\u304f\u3068\u3082" : "";
        if (this.ctGuardVillage > 0) {
            result.append(atLeast);
            result.append("\u6751\u9663\u55b6\u3092");
            result.append(this.ctGuardVillage);
            result.append("\u56de\u8b77\u885b\u3057");
            if (this.ctGuardVillageGJ > 0) {
                result.append("GJ\u3092");
                result.append(this.ctGuardVillageGJ);
                result.append("\u56de\u51fa\u3057\u305f\u3002");
            } else {
                result.append("\u305f\u3002");
            }
        }
        if (this.ctGuardHamster > 0) {
            result.append(atLeast);
            result.append("\u30cf\u30e0\u30b9\u30bf\u30fc\u3092");
            result.append(this.ctGuardHamster);
            result.append("\u56de\u8b77\u885b\u3057");
            if (this.ctGuardHamsterGJ > 0) {
                result.append("GJ\u3092");
                result.append(this.ctGuardHamsterGJ);
                result.append("\u56de\u51fa\u3057\u305f\u3002");
            } else {
                result.append("\u305f\u3002");
            }
        }
        if (this.ctGuardMadman > 0) {
            result.append(atLeast);
            result.append("\u72c2\u4eba\u3092");
            result.append(this.ctGuardMadman);
            result.append("\u56de\u8b77\u885b\u3057");
            if (this.ctGuardMadmanGJ > 0) {
                result.append("GJ\u3092");
                result.append(this.ctGuardMadmanGJ);
                result.append("\u56de\u51fa\u3057\u305f\u3002");
            } else {
                result.append("\u305f\u3002");
            }
        }
        if (this.ctGuardWolf > 0) {
            result.append(atLeast);
            result.append("\u4eba\u72fc\u3092");
            result.append(this.ctGuardWolf);
            result.append("\u56de\u8b77\u885b\u3057\u305f\u3002");
        }
        if (this.ctGuardFakeGJ > 0) {
            result.append("\u8b77\u885b\u5148\u306f\u4e0d\u660e\u306a\u304c\u3089\u507d\u88c5GJ\u304c");
            result.append(this.ctGuardFakeGJ);
            result.append("\u56de\u3042\u3063\u305f\u3002");
        }
        if (result.length() <= 0) {
            result.append("\u8ab0\u3082\u8b77\u885b\u3067\u304d\u306a\u304b\u3063\u305f");
        }
        CharSequence seq = WolfBBS.escapeWikiSyntax(result);
        return seq;
    }

    public CharSequence dumpExecutionInfo() {
        StringBuilder result = new StringBuilder();
        int exeWolf = 0;
        int exeMad = 0;
        int exeVillage = 0;
        block4: for (Player player : this.playerList) {
            Destiny destiny = player.getDestiny();
            if (destiny != Destiny.EXECUTED) continue;
            GameRole role = player.getRole();
            switch (role) {
                case WOLF: {
                    ++exeWolf;
                    continue block4;
                }
                case MADMAN: {
                    ++exeMad;
                    continue block4;
                }
            }
            ++exeVillage;
        }
        if (exeVillage > 0) {
            result.append("\u25bc\u6751\u9663\u55b6\u00d7").append(exeVillage).append("\u56de");
        }
        if (exeMad > 0) {
            if (result.length() > 0) {
                result.append("\u3001");
            }
            result.append("\u25bc\u72c2\u00d7").append(exeMad).append("\u56de");
        }
        if (exeWolf > 0) {
            if (result.length() > 0) {
                result.append("\u3001");
            }
            result.append("\u25bc\u72fc\u00d7").append(exeWolf).append("\u56de");
        }
        if (result.length() <= 0) {
            result.append("\u306a\u3057");
        }
        CharSequence seq = WolfBBS.escapeWikiSyntax(result);
        return seq;
    }

    public CharSequence dumpAssaultInfo() {
        StringBuilder result = new StringBuilder();
        int eatMad = 0;
        int eatVillage = 0;
        block3: for (Player player : this.playerList) {
            if (player.getAvatar() == Avatar.AVATAR_GERD) {
                result.append("\u25b2\u30b2\u30eb\u30c8");
                continue;
            }
            Destiny destiny = player.getDestiny();
            if (destiny != Destiny.EATEN) continue;
            GameRole role = player.getRole();
            switch (role) {
                case MADMAN: {
                    ++eatMad;
                    continue block3;
                }
            }
            ++eatVillage;
        }
        if (eatVillage > 0) {
            if (result.length() > 0) {
                result.append("\u3001");
            }
            result.append("\u25b2\u6751\u9663\u55b6\u00d7").append(eatVillage).append("\u56de");
        }
        if (eatMad > 0) {
            if (result.length() > 0) {
                result.append("\u3001");
            }
            result.append("\u25b2\u72c2\u00d7").append(eatMad).append("\u56de");
        }
        if (result.length() <= 0) {
            result.append("\u8972\u6483\u306a\u3057");
        }
        CharSequence seq = WolfBBS.escapeWikiSyntax(result);
        return seq;
    }

    public CharSequence dumpVoteBox() {
        StringBuilder wikiText = new StringBuilder();
        for (Player player : this.getCastingPlayerList()) {
            Avatar avatar = player.getAvatar();
            if (avatar == Avatar.AVATAR_GERD) continue;
            GameRole role = player.getRole();
            String fullName = avatar.getFullName();
            String roleName = role.getRoleName();
            StringBuilder line = new StringBuilder();
            line.append("[").append((CharSequence)roleName).append("] ").append((CharSequence)fullName);
            if (wikiText.length() > 0) {
                wikiText.append(',');
            }
            wikiText.append(WolfBBS.escapeWikiSyntax(line));
            wikiText.append("[0]");
        }
        wikiText.insert(0, "#vote(").append(")\n");
        return wikiText;
    }

    public CharSequence dumpCastingBoard(FaceIconSet iconSet) {
        StringBuilder wikiText = new StringBuilder();
        String vName = this.village.getVillageFullName();
        String generator = Jindolf.TITLE + " Ver." + Jindolf.VERSION;
        String author = iconSet.getAuthor() + "\u6c0f" + " [ " + iconSet.getUrlText() + " ]";
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("// \u2193\u30ad\u30e3\u30b9\u30c8\u8868\u958b\u59cb\n");
        wikiText.append("//        Village : " + vName + "\n");
        wikiText.append("//        Generator : " + generator + "\n");
        wikiText.append("//        \u30a2\u30a4\u30b3\u30f3\u4f5c\u8005 : " + author + '\n');
        wikiText.append("// \u203b\u30a2\u30a4\u30b3\u30f3\u753b\u50cf\u306e\u8457\u4f5c\u8ca1\u7523\u6a29\u4fdd\u6301\u8005\u304a\u3088\u3073\u753b\u50cf\u30b5\u30fc\u30d0\u904b\u55b6\u8005\u304b\u3089\n");
        wikiText.append("// \u65b0\u3057\u3044\u610f\u5411\u304c\u793a\u3055\u308c\u305f\u5834\u5408\u3001\u305d\u3061\u3089\u3092\u6700\u512a\u5148\u3067\u5c0a\u91cd\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n");
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("|\u914d\u5f79").append("|\u53c2\u52a0\u8005").append("|\u5f79\u8077").append("|\u904b\u547d").append("|\u305d\u306e\u6d3b\u8e8d").append("|h").append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        for (Player player : this.getCastingPlayerList()) {
            CharSequence report;
            Avatar avatar = player.getAvatar();
            GameRole role = player.getRole();
            Destiny destiny = player.getDestiny();
            int obitDay = player.getObitDay();
            String name = player.getIdName();
            String urlText = player.getUrlText();
            if (urlText == null) {
                urlText = "";
            }
            urlText = urlText.replace("~", "%7e");
            urlText = urlText.replace(" ", "%20");
            try {
                URL url = new URL(urlText);
                URI uri = url.toURI();
                urlText = uri.toASCIIString();
            }
            catch (MalformedURLException e) {
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            wikiText.append("// ========== ");
            wikiText.append(name + " acts as [" + avatar.getName() + "]");
            wikiText.append(" ==========\n");
            String teamColor = "BGCOLOR(" + WolfBBS.getTeamWikiColor(role) + "):";
            String avatarIcon = iconSet.getAvatarIconWiki(avatar);
            wikiText.append('|').append(teamColor);
            wikiText.append(avatarIcon).append("&br;");
            wikiText.append("[[").append(avatar.getName()).append("]]");
            wikiText.append('|').append(teamColor);
            wikiText.append("[[").append(WolfBBS.escapeWikiBracket(name));
            if (urlText != null && urlText.length() > 0) {
                wikiText.append('>').append(urlText);
            }
            wikiText.append("]]");
            wikiText.append('|').append(teamColor);
            wikiText.append(WolfBBS.getRoleIconWiki(role));
            wikiText.append("&br;");
            wikiText.append("[[");
            wikiText.append(role.getRoleName());
            wikiText.append("]]");
            String destinyColor = WolfBBS.getDestinyColorWiki(destiny);
            wikiText.append('|');
            wikiText.append("BGCOLOR(").append(destinyColor).append("):");
            if (destiny == Destiny.ALIVE) {
                wikiText.append("\u6700\u5f8c\u307e\u3067&br;\u751f\u5b58");
            } else {
                wikiText.append(obitDay).append("\u65e5\u76ee").append("&br;");
                wikiText.append(destiny.getMessage());
            }
            wikiText.append('|');
            wikiText.append(avatar.getJobTitle()).append('\u3002');
            if (avatar == Avatar.AVATAR_GERD) {
                wikiText.append("\u5bdd\u3066\u3070\u304b\u308a\u3044\u305f\u3002");
            } else if (role == GameRole.HUNTER) {
                report = this.dumpHunterActivity();
                wikiText.append(report);
            } else if (role == GameRole.SEER) {
                report = this.dumpSeerActivity();
                wikiText.append(report);
            }
            wikiText.append("|\n");
        }
        wikiText.append("|>|>|>|>|");
        wikiText.append("RIGHT:");
        wikiText.append("\u9854\u30a2\u30a4\u30b3\u30f3\u63d0\u4f9b : [[");
        wikiText.append(WolfBBS.escapeWikiBracket(iconSet.getAuthor()));
        wikiText.append(">" + iconSet.getUrlText());
        wikiText.append("]]\u6c0f");
        wikiText.append("|\n");
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("// \u2191\u30ad\u30e3\u30b9\u30c8\u8868\u3053\u3053\u307e\u3067\n");
        wikiText.append(WolfBBS.COMMENTLINE);
        return wikiText;
    }

    public CharSequence dumpVillageWiki() {
        StringBuilder wikiText = new StringBuilder();
        DateFormat dform = DateFormat.getDateTimeInstance(0, 0);
        String vName = this.village.getVillageFullName();
        String generator = Jindolf.TITLE + " Ver." + Jindolf.VERSION;
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("// \u2193\u6751\u8a73\u7d30\u958b\u59cb\n");
        wikiText.append("//        Village : " + vName + "\n");
        wikiText.append("//        Generator : " + generator + "\n");
        wikiText.append("* \u6751\u306e\u8a73\u7d30\n");
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u52dd\u8005\n");
        Team winnerTeam = this.getWinnerTeam();
        String wonTeam = winnerTeam.getTeamName();
        wikiText.append(wonTeam).append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u30a8\u30f3\u30c8\u30ea\u30fc\u958b\u59cb\u6642\u523b\n");
        Date date = this.get1stTalkDate();
        String talk1st = dform.format(date);
        wikiText.append(talk1st).append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u53c2\u52a0\u4eba\u6570\n");
        int avatarNum = this.countAvatarNum();
        String totalMember = "\u30b2\u30eb\u30c8 + " + (avatarNum - 1) + "\u540d = " + avatarNum + "\u540d";
        wikiText.append(WolfBBS.escapeWikiSyntax(totalMember)).append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u5f79\u8077\u5185\u8a33\n");
        StringBuilder roleMsg = new StringBuilder();
        for (GameRole role : GameRole.values()) {
            List<Player> players = this.getRoledPlayerList(role);
            String roleName = role.getRoleName();
            if (players.size() <= 0) continue;
            if (roleMsg.length() > 0) {
                roleMsg.append('\u3001');
            }
            roleMsg.append(roleName).append(" \u00d7 ").append(players.size()).append("\u540d");
        }
        wikiText.append(WolfBBS.escapeWikiSyntax(roleMsg)).append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u51e6\u5211\u5185\u8a33\n");
        wikiText.append(this.dumpExecutionInfo()).append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u8972\u6483\u5185\u8a33\n");
        wikiText.append(this.dumpAssaultInfo()).append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u7a81\u7136\u6b7b\n");
        wikiText.append(this.countSuddenDeath()).append("\u540d").append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u4eba\u53e3\u63a8\u79fb\n");
        for (int day = 1; day < this.village.getPeriodSize(); ++day) {
            List<Player> players = this.getSurvivorList(day);
            String roleSeq = GameSummary.getRoleBalanceSequence(players);
            Period period = this.village.getPeriod(day);
            String daySeq = period.getCaption();
            wikiText.append('|').append(daySeq).append('|').append((CharSequence)roleSeq).append("|\n");
        }
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u5360\u3044\u5e2b\u306e\u6210\u7e3e\n");
        wikiText.append(this.dumpSeerActivity()).append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u72e9\u4eba\u306e\u6210\u7e3e\n");
        wikiText.append(this.dumpHunterActivity()).append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("// \u2191\u6751\u8a73\u7d30\u3053\u3053\u307e\u3067\n");
        wikiText.append(WolfBBS.COMMENTLINE);
        return wikiText;
    }

    public Date get1stTalkDate() {
        return new Date(this.talk1stTimeMs);
    }

    public Date getLastTalkDate() {
        return new Date(this.talkLastTimeMs);
    }

    public List<Player> getSurvivorList(int day) {
        if (day < 0 || this.village.getPeriodSize() <= day) {
            throw new IndexOutOfBoundsException();
        }
        LinkedList<Player> result = new LinkedList<Player>();
        Period period = this.village.getPeriod(day);
        if (period.isPrologue() || period.isProgress() && day == 1) {
            result.addAll(this.playerList);
            return result;
        }
        if (period.isEpilogue()) {
            for (Player player : this.playerList) {
                if (player.getDestiny() != Destiny.ALIVE) continue;
                result.add(player);
            }
            return result;
        }
        for (Topic topic : period.getTopicList()) {
            SysEvent sysEvent;
            if (!(topic instanceof SysEvent) || (sysEvent = (SysEvent)topic).getSysEventType() != SysEventType.SURVIVOR) continue;
            List<Avatar> avatarList = sysEvent.getAvatarList();
            for (Avatar avatar : avatarList) {
                Player player = this.getPlayer(avatar);
                result.add(player);
            }
        }
        return result;
    }

    public List<Player> getPlayerList() {
        List<Player> result = Collections.unmodifiableList(this.playerList);
        return result;
    }

    public List<Player> getCastingPlayerList() {
        LinkedList<Player> sortedPlayers = new LinkedList<Player>();
        sortedPlayers.addAll(this.playerList);
        Collections.sort(sortedPlayers, COMPARATOR_CASTING);
        return sortedPlayers;
    }

    public List<Player> getRoledPlayerList(GameRole role) {
        LinkedList<Player> result = new LinkedList<Player>();
        for (Player player : this.playerList) {
            if (player.getRole() != role) continue;
            result.add(player);
        }
        return result;
    }

    public Team getWinnerTeam() {
        return this.winner;
    }

    public int countSuddenDeath() {
        int suddenDeath = 0;
        for (Player player : this.playerList) {
            if (player.getDestiny() != Destiny.SUDDENDEATH) continue;
            ++suddenDeath;
        }
        return suddenDeath;
    }

    public int countAvatarNum() {
        int playerNum = this.playerList.size();
        return playerNum;
    }

    public final Player getPlayer(Avatar avatar) {
        Player player = this.playerMap.get(avatar);
        return player;
    }

    private Player registPlayer(Avatar avatar) {
        Player player = this.getPlayer(avatar);
        if (player == null) {
            player = new Player();
            player.setAvatar(avatar);
            this.playerMap.put(avatar, player);
        }
        return player;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CastingComparator
    implements Comparator<Player> {
        private CastingComparator() {
        }

        @Override
        public int compare(Player p1, Player p2) {
            int obitDay2;
            int obitDay1;
            Destiny dest2;
            Avatar avatar2;
            if (p1 == p2) {
                return 0;
            }
            if (p1 == null) {
                return -1;
            }
            if (p2 == null) {
                return 1;
            }
            Avatar avatar1 = p1.getAvatar();
            if (avatar1.equals(avatar2 = p2.getAvatar())) {
                return 0;
            }
            if (avatar1 == Avatar.AVATAR_GERD) {
                return -1;
            }
            if (avatar2 == Avatar.AVATAR_GERD) {
                return 1;
            }
            Destiny dest1 = p1.getDestiny();
            if (dest1 != (dest2 = p2.getDestiny())) {
                if (dest1 == Destiny.ALIVE) {
                    return 1;
                }
                if (dest2 == Destiny.ALIVE) {
                    return -1;
                }
            }
            if ((obitDay1 = p1.getObitDay()) > (obitDay2 = p2.getObitDay())) {
                return 1;
            }
            if (obitDay1 < obitDay2) {
                return -1;
            }
            int destinyOrder = dest1.compareTo(dest2);
            if (destinyOrder != 0) {
                return destinyOrder;
            }
            int entryOrder = p1.getEntryNo() - p2.getEntryNo();
            return entryOrder;
        }
    }
}

