/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class UriExporter
implements Transferable {
    private static final String[] mimes = new String[]{"text/uri-list", "text/plain"};
    private static final List<DataFlavor> uriFlavors = new ArrayList<DataFlavor>(mimes.length);
    private URI uri;

    public UriExporter(URI uRI) {
        this.uri = uRI;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[uriFlavors.size()];
        int n = 0;
        for (DataFlavor dataFlavor : uriFlavors) {
            try {
                dataFlavorArray[n++] = (DataFlavor)dataFlavor.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                assert (false);
                return null;
            }
        }
        return dataFlavorArray;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (DataFlavor dataFlavor2 : uriFlavors) {
            if (!dataFlavor2.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        String string = this.uri.toASCIIString();
        return string;
    }

    static {
        String string = "class=" + String.class.getName();
        for (String string2 : mimes) {
            DataFlavor dataFlavor;
            string2 = string2 + "; " + string;
            try {
                dataFlavor = new DataFlavor(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                assert (false);
                throw new ExceptionInInitializerError(classNotFoundException);
            }
            uriFlavors.add(dataFlavor);
        }
    }
}

