/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jp.sourceforge.jindolf.ClipboardAction;

public class TextPopup
extends JPopupMenu
implements PropertyChangeListener {
    protected static final String PROPERTY_UI = "UI";
    protected final Action cutAction = ClipboardAction.cutAction();
    protected final Action copyAction = ClipboardAction.copyAction();
    protected final Action pasteAction = ClipboardAction.pasteAction();
    protected final Action selallAction = ClipboardAction.selectallAction();

    public TextPopup() {
        this.buildMenu();
    }

    protected void buildMenu() {
        this.add(this.cutAction);
        this.add(this.copyAction);
        this.add(this.pasteAction);
        this.addSeparator();
        this.add(this.selallAction);
    }

    protected boolean hasSelectedContent(JTextComponent jTextComponent) {
        int n;
        int n2 = jTextComponent.getSelectionStart();
        boolean bl = n2 != (n = jTextComponent.getSelectionEnd());
        return bl;
    }

    protected boolean hasContent(JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        int n = document.getLength();
        return n > 0;
    }

    public void setInvoker(Component component) {
        Component component2 = this.getInvoker();
        if (component2 != null) {
            component2.removePropertyChangeListener(this);
        }
        super.setInvoker(component);
        if (component != null) {
            component.addPropertyChangeListener(PROPERTY_UI, this);
        }
    }

    public void show(Component component, int n, int n2) {
        if (!(component instanceof JTextComponent)) {
            return;
        }
        JTextComponent jTextComponent = (JTextComponent)component;
        boolean bl = this.hasSelectedContent(jTextComponent);
        this.cutAction.setEnabled(bl);
        this.copyAction.setEnabled(bl);
        if (!jTextComponent.isEditable()) {
            this.cutAction.setEnabled(false);
            this.pasteAction.setEnabled(false);
        }
        if (this.hasContent(jTextComponent)) {
            this.selallAction.setEnabled(true);
        } else {
            this.selallAction.setEnabled(false);
        }
        super.show(component, n, n2);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (PROPERTY_UI.equals(string)) {
            this.updateUI();
        }
    }
}

