/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import jp.sourceforge.jindolf.HttpUtils;
import jp.sourceforge.jindolf.Jindolf;

public class TallyOutputStream
extends OutputStream {
    private static final int BUFSIZE = 512;
    private final HttpURLConnection conn;
    private final OutputStream out;
    private long counter;
    private long nanoLap;

    public static OutputStream getOutputStream(HttpURLConnection httpURLConnection) throws IOException {
        return new TallyOutputStream(httpURLConnection);
    }

    protected TallyOutputStream(HttpURLConnection httpURLConnection) throws IOException {
        this.conn = httpURLConnection;
        this.counter = 0L;
        this.nanoLap = 0L;
        OutputStream outputStream = this.conn.getOutputStream();
        this.out = outputStream = new BufferedOutputStream(outputStream, 512);
    }

    protected long getCount() {
        return this.counter;
    }

    public void close() throws IOException {
        this.out.close();
        long l = this.getCount();
        long l2 = System.nanoTime() - this.nanoLap;
        String string = HttpUtils.formatHttpStat(this.conn, l, l2);
        Jindolf.logger.info(string);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(byte[] byArray) throws IOException {
        if (this.counter <= 0L) {
            this.nanoLap = System.nanoTime();
        }
        this.out.write(byArray);
        this.counter += (long)byArray.length;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.counter <= 0L) {
            this.nanoLap = System.nanoTime();
        }
        this.out.write(byArray, n, n2);
        this.counter += (long)n2;
    }

    public void write(int n) throws IOException {
        if (this.counter <= 0L) {
            this.nanoLap = System.nanoTime();
        }
        this.out.write(n);
        ++this.counter;
    }
}

