/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import jp.sourceforge.jindolf.AccountCookie;
import jp.sourceforge.jindolf.HtmlSequence;
import jp.sourceforge.jindolf.HttpUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.SjisInputStream;
import jp.sourceforge.jindolf.TallyInputStream;
import jp.sourceforge.jindolf.TallyOutputStream;
import jp.sourceforge.jindolf.Village;

public class ServerAccess {
    private static final String USER_AGENT = HttpUtils.getUserAgentName();
    private static final String ENCODING_HTML = "Shift_JIS";
    private static final Charset CHARSET_SJIS = Charset.forName("Shift_JIS");
    private static final int BUF_SIZE = 1024;
    private static final String JINRO_CGI = "./index.rb";
    private static final Map<String, SoftReference<Image>> imageCache;
    private final URL baseURL;
    private long lastServerMs;
    private long lastLocalMs;
    private long lastSystemMs;
    private AccountCookie cookieAuth = null;
    private String encodedUserID = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image getImageCache(String string) {
        Image image;
        if (string == null) {
            return null;
        }
        Map<String, SoftReference<Image>> map = imageCache;
        synchronized (map) {
            SoftReference<Image> softReference = imageCache.get(string);
            if (softReference == null) {
                return null;
            }
            Image image2 = softReference.get();
            if (image2 == null) {
                imageCache.remove(string);
                return null;
            }
            image = image2;
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putImageCache(String string, Image image) {
        if (string == null || image == null) {
            return;
        }
        Map<String, SoftReference<Image>> map = imageCache;
        synchronized (map) {
            if (ServerAccess.getImageCache(string) != null) {
                return;
            }
            SoftReference<Image> softReference = new SoftReference<Image>(image);
            imageCache.put(string, softReference);
        }
    }

    public static String formEncode(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        try {
            string2 = URLEncoder.encode(string, ENCODING_HTML);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false);
            string2 = null;
        }
        return string2;
    }

    public static String formEncode(char[] cArray) {
        return ServerAccess.formEncode(new String(cArray));
    }

    public static CharSequence downloadHTMLStream(InputStream inputStream) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        Reader reader = new InputStreamReader(inputStream, CHARSET_SJIS);
        reader = new BufferedReader(reader, 1024);
        char[] cArray = new char[1024];
        while ((n = reader.read(cArray)) > 0) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder;
    }

    public ServerAccess(URL uRL) {
        this.baseURL = uRL;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    protected URL getQueryURL(String string) {
        URL uRL;
        if (string.length() >= 1 && string.charAt(0) != '?') {
            return null;
        }
        try {
            uRL = new URL(this.getBaseURL(), JINRO_CGI + string);
        }
        catch (MalformedURLException malformedURLException) {
            assert (false);
            return null;
        }
        return uRL;
    }

    protected HtmlSequence downloadHTML(String string) throws IOException {
        URL uRL = this.getQueryURL(string);
        HtmlSequence htmlSequence = this.downloadHTML(uRL);
        return htmlSequence;
    }

    protected HtmlSequence downloadHTML(URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestProperty("Accept", "*/*");
        httpURLConnection.setRequestProperty("User-Agent", USER_AGENT);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setRequestMethod("GET");
        AccountCookie accountCookie = this.cookieAuth;
        if (accountCookie != null) {
            if (ServerAccess.shouldAccept(uRL, accountCookie)) {
                httpURLConnection.setRequestProperty("Cookie", "login=" + accountCookie.getLoginData());
            } else {
                this.clearAuthentication();
            }
        }
        httpURLConnection.connect();
        this.updateLastAccess(httpURLConnection);
        int n = httpURLConnection.getResponseCode();
        if (n != 200) {
            String string = "\u767a\u8a00\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            string = string + HttpUtils.formatHttpStat(httpURLConnection, 0L, 0L);
            Jindolf.logger.log(Level.WARNING, string);
            return null;
        }
        String string = HttpUtils.getHTMLCharset(httpURLConnection);
        if (!string.equalsIgnoreCase(ENCODING_HTML)) {
            return null;
        }
        InputStream inputStream = TallyInputStream.getInputStream(httpURLConnection);
        SjisInputStream sjisInputStream = new SjisInputStream(inputStream);
        CharSequence charSequence = ServerAccess.downloadHTMLStream(sjisInputStream);
        sjisInputStream.close();
        httpURLConnection.disconnect();
        SortedMap<Long, byte[]> sortedMap = sjisInputStream.getEncodeError();
        HtmlSequence htmlSequence = new HtmlSequence(uRL, charSequence, sortedMap);
        return htmlSequence;
    }

    public Image downloadImage(String string) throws IOException {
        URL uRL;
        Object object;
        try {
            object = this.getBaseURL();
            uRL = new URL((URL)object, string);
        }
        catch (MalformedURLException malformedURLException) {
            assert (false);
            return null;
        }
        object = ServerAccess.getImageCache(uRL.toString());
        if (object != null) {
            return object;
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestProperty("Accept", "*/*");
        httpURLConnection.setRequestProperty("User-Agent", USER_AGENT);
        httpURLConnection.setUseCaches(true);
        httpURLConnection.setInstanceFollowRedirects(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.connect();
        int n = httpURLConnection.getResponseCode();
        if (n != 200) {
            String string2 = "\u30a4\u30e1\u30fc\u30b8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            string2 = string2 + HttpUtils.formatHttpStat(httpURLConnection, 0L, 0L);
            Jindolf.logger.log(Level.WARNING, string2);
            return null;
        }
        InputStream inputStream = TallyInputStream.getInputStream(httpURLConnection);
        object = ImageIO.read(inputStream);
        inputStream.close();
        httpURLConnection.disconnect();
        ServerAccess.putImageCache(uRL.toString(), (Image)object);
        return object;
    }

    protected boolean postAuthData(String string) throws IOException {
        URL uRL = this.getQueryURL("");
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestProperty("Accept", "*/*");
        httpURLConnection.setRequestProperty("User-Agent", USER_AGENT);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        byte[] byArray = string.getBytes();
        OutputStream outputStream = TallyOutputStream.getOutputStream(httpURLConnection);
        outputStream.write(byArray);
        outputStream.flush();
        outputStream.close();
        this.updateLastAccess(httpURLConnection);
        int n = httpURLConnection.getResponseCode();
        if (n != 302) {
            String string2 = "\u8a8d\u8a3c\u60c5\u5831\u306e\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            Jindolf.logger.log(Level.WARNING, string2);
            httpURLConnection.disconnect();
            return false;
        }
        httpURLConnection.disconnect();
        AccountCookie accountCookie = AccountCookie.createCookie(httpURLConnection);
        if (accountCookie == null) {
            return false;
        }
        this.setAuthentication(accountCookie);
        Jindolf.logger.info("\u6b63\u3057\u304f\u8a8d\u8a3c\u304c\u884c\u308f\u308c\u307e\u3057\u305f\u3002");
        return true;
    }

    public HtmlSequence getHTMLTopPage() throws IOException {
        return this.downloadHTML("");
    }

    public HtmlSequence getHTMLLandList() throws IOException {
        return this.downloadHTML("?cmd=log");
    }

    public HtmlSequence getHTMLBoneHead(Village village) throws IOException {
        String string = village.getVillageID();
        return this.downloadHTML("?vid=" + string + "&meslog=");
    }

    public HtmlSequence getHTMLVillage(Village village) throws IOException {
        URL uRL = this.getVillageURL(village);
        return this.downloadHTML(uRL);
    }

    public URL getVillageURL(Village village) {
        String string = village.getVillageID();
        URL uRL = this.getQueryURL("?vid=" + string);
        return uRL;
    }

    public HtmlSequence getHTMLPeriod(Period period) throws IOException {
        URL uRL = this.getPeriodURL(period);
        return this.downloadHTML(uRL);
    }

    public URL getPeriodURL(Period period) {
        String string = period.getCGIQuery();
        URL uRL = this.getQueryURL(string);
        return uRL;
    }

    public void updateLastAccess(HttpURLConnection httpURLConnection) {
        this.lastServerMs = httpURLConnection.getDate();
        this.lastLocalMs = System.currentTimeMillis();
        this.lastSystemMs = System.nanoTime() / 1000000L;
    }

    private static boolean shouldAccept(URL uRL, AccountCookie accountCookie) {
        String string;
        if (accountCookie.hasExpired()) {
            return false;
        }
        String string2 = uRL.getPath();
        return string2.startsWith(string = accountCookie.getPathURI().getPath());
    }

    public boolean hasLoggedIn() {
        AccountCookie accountCookie = this.cookieAuth;
        if (accountCookie == null) {
            return false;
        }
        if (accountCookie.hasExpired()) {
            this.clearAuthentication();
            return false;
        }
        return true;
    }

    public final boolean login(String string, char[] cArray) throws IOException {
        boolean bl;
        if (this.hasLoggedIn()) {
            return true;
        }
        String string2 = ServerAccess.formEncode(string);
        if (string2 == null || string2.length() <= 0) {
            return false;
        }
        String string3 = ServerAccess.formEncode(cArray);
        if (string3 == null || string3.length() <= 0) {
            return false;
        }
        this.encodedUserID = string2;
        String string4 = ServerAccess.formEncode("&#bottom");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("cmd=login");
        stringBuilder.append('&').append("cgi_param=").append(string4);
        stringBuilder.append('&').append("user_id=").append(string2);
        stringBuilder.append('&').append("password=").append(string3);
        try {
            bl = this.postAuthData(stringBuilder.toString());
        }
        catch (IOException iOException) {
            this.clearAuthentication();
            throw iOException;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() throws IOException {
        if (!this.hasLoggedIn()) {
            return;
        }
        if (this.encodedUserID == null) {
            this.clearAuthentication();
            return;
        }
        String string = ServerAccess.formEncode("&#bottom");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("cmd=logout");
        stringBuilder.append('&').append("cgi_param=").append(string);
        stringBuilder.append('&').append("user_id=").append(this.encodedUserID);
        try {
            this.postAuthData(stringBuilder.toString());
        }
        finally {
            this.clearAuthentication();
        }
    }

    protected void clearAuthentication() {
        this.cookieAuth = null;
        this.encodedUserID = null;
    }

    private void setAuthentication(AccountCookie accountCookie) {
        this.cookieAuth = accountCookie;
    }

    static {
        HashMap hashMap = new HashMap();
        imageCache = Collections.synchronizedMap(hashMap);
    }
}

