/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.text.CharacterIterator;

public class SequenceCharacterIterator
implements CharacterIterator {
    private final CharSequence source;
    private final int cursorBegin;
    private final int cursorEnd;
    private final int cursorLength;
    private int cursorPos;

    public SequenceCharacterIterator(CharSequence charSequence, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || charSequence.length() < n2) {
            throw new IndexOutOfBoundsException();
        }
        this.source = charSequence;
        this.cursorBegin = n;
        this.cursorEnd = n2;
        this.cursorLength = this.cursorEnd - this.cursorBegin;
        this.cursorPos = this.cursorBegin;
    }

    public SequenceCharacterIterator(CharSequence charSequence) {
        this.source = charSequence;
        this.cursorBegin = 0;
        this.cursorEnd = charSequence.length();
        this.cursorLength = this.cursorEnd - this.cursorBegin;
        this.cursorPos = this.cursorBegin;
    }

    public char first() {
        this.cursorPos = this.cursorBegin;
        return this.current();
    }

    public char last() {
        this.cursorPos = this.cursorEnd - 1;
        return this.current();
    }

    public char current() {
        if (this.cursorLength <= 0 || this.cursorPos < this.cursorBegin) {
            this.cursorPos = this.cursorBegin;
            return '\uffff';
        }
        if (this.cursorPos >= this.cursorEnd) {
            this.cursorPos = this.cursorEnd;
            return '\uffff';
        }
        return this.source.charAt(this.cursorPos);
    }

    public char next() {
        ++this.cursorPos;
        return this.current();
    }

    public char previous() {
        --this.cursorPos;
        return this.current();
    }

    public char setIndex(int n) throws IllegalArgumentException {
        if (n < this.cursorBegin || this.cursorEnd < n) {
            throw new IllegalArgumentException();
        }
        this.cursorPos = n;
        return this.current();
    }

    public int getBeginIndex() {
        return this.cursorBegin;
    }

    public int getEndIndex() {
        return this.cursorEnd;
    }

    public int getIndex() {
        return this.cursorPos;
    }

    public Object clone() {
        Object object;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
        return object;
    }
}

